// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package certificateservice

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opQuickApplyCertificateCommon = "QuickApplyCertificate"

// QuickApplyCertificateCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the QuickApplyCertificateCommon operation. The "output" return
// value will be populated with the QuickApplyCertificateCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned QuickApplyCertificateCommon Request to send the API call to the service.
// the "output" return value is not valid until after QuickApplyCertificateCommon Send returns without error.
//
// See QuickApplyCertificateCommon for more information on using the QuickApplyCertificateCommon
// API call, and error handling.
//
//    // Example sending a request using the QuickApplyCertificateCommonRequest method.
//    req, resp := client.QuickApplyCertificateCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CERTIFICATESERVICE) QuickApplyCertificateCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opQuickApplyCertificateCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// QuickApplyCertificateCommon API operation for CERTIFICATE_SERVICE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CERTIFICATE_SERVICE's
// API operation QuickApplyCertificateCommon for usage and error information.
func (c *CERTIFICATESERVICE) QuickApplyCertificateCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.QuickApplyCertificateCommonRequest(input)
	return out, req.Send()
}

// QuickApplyCertificateCommonWithContext is the same as QuickApplyCertificateCommon with the addition of
// the ability to pass a context and additional request options.
//
// See QuickApplyCertificateCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CERTIFICATESERVICE) QuickApplyCertificateCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.QuickApplyCertificateCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opQuickApplyCertificate = "QuickApplyCertificate"

// QuickApplyCertificateRequest generates a "volcengine/request.Request" representing the
// client's request for the QuickApplyCertificate operation. The "output" return
// value will be populated with the QuickApplyCertificateCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned QuickApplyCertificateCommon Request to send the API call to the service.
// the "output" return value is not valid until after QuickApplyCertificateCommon Send returns without error.
//
// See QuickApplyCertificate for more information on using the QuickApplyCertificate
// API call, and error handling.
//
//    // Example sending a request using the QuickApplyCertificateRequest method.
//    req, resp := client.QuickApplyCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CERTIFICATESERVICE) QuickApplyCertificateRequest(input *QuickApplyCertificateInput) (req *request.Request, output *QuickApplyCertificateOutput) {
	op := &request.Operation{
		Name:       opQuickApplyCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &QuickApplyCertificateInput{}
	}

	output = &QuickApplyCertificateOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// QuickApplyCertificate API operation for CERTIFICATE_SERVICE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CERTIFICATE_SERVICE's
// API operation QuickApplyCertificate for usage and error information.
func (c *CERTIFICATESERVICE) QuickApplyCertificate(input *QuickApplyCertificateInput) (*QuickApplyCertificateOutput, error) {
	req, out := c.QuickApplyCertificateRequest(input)
	return out, req.Send()
}

// QuickApplyCertificateWithContext is the same as QuickApplyCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See QuickApplyCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CERTIFICATESERVICE) QuickApplyCertificateWithContext(ctx volcengine.Context, input *QuickApplyCertificateInput, opts ...request.Option) (*QuickApplyCertificateOutput, error) {
	req, out := c.QuickApplyCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type QuickApplyCertificateInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CommonName *string `type:"string" json:",omitempty"`

	Csr *string `type:"string" json:",omitempty"`

	KeyAlg *string `type:"string" json:",omitempty" enum:"EnumOfKeyAlgForQuickApplyCertificateInput"`

	// OrganizationId is a required field
	OrganizationId *string `type:"string" json:",omitempty" required:"true"`

	// Plan is a required field
	Plan *string `type:"string" json:",omitempty" required:"true"`

	PrivateKey *string `type:"string" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	San []*string `type:"list" json:",omitempty"`

	Tag *string `type:"string" json:",omitempty"`

	Tags []*TagForQuickApplyCertificateInput `type:"list" json:",omitempty"`

	// ValidationType is a required field
	ValidationType *string `type:"string" json:",omitempty" required:"true" enum:"EnumOfValidationTypeForQuickApplyCertificateInput"`
}

// String returns the string representation
func (s QuickApplyCertificateInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s QuickApplyCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QuickApplyCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QuickApplyCertificateInput"}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.Plan == nil {
		invalidParams.Add(request.NewErrParamRequired("Plan"))
	}
	if s.ValidationType == nil {
		invalidParams.Add(request.NewErrParamRequired("ValidationType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommonName sets the CommonName field's value.
func (s *QuickApplyCertificateInput) SetCommonName(v string) *QuickApplyCertificateInput {
	s.CommonName = &v
	return s
}

// SetCsr sets the Csr field's value.
func (s *QuickApplyCertificateInput) SetCsr(v string) *QuickApplyCertificateInput {
	s.Csr = &v
	return s
}

// SetKeyAlg sets the KeyAlg field's value.
func (s *QuickApplyCertificateInput) SetKeyAlg(v string) *QuickApplyCertificateInput {
	s.KeyAlg = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *QuickApplyCertificateInput) SetOrganizationId(v string) *QuickApplyCertificateInput {
	s.OrganizationId = &v
	return s
}

// SetPlan sets the Plan field's value.
func (s *QuickApplyCertificateInput) SetPlan(v string) *QuickApplyCertificateInput {
	s.Plan = &v
	return s
}

// SetPrivateKey sets the PrivateKey field's value.
func (s *QuickApplyCertificateInput) SetPrivateKey(v string) *QuickApplyCertificateInput {
	s.PrivateKey = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *QuickApplyCertificateInput) SetProjectName(v string) *QuickApplyCertificateInput {
	s.ProjectName = &v
	return s
}

// SetSan sets the San field's value.
func (s *QuickApplyCertificateInput) SetSan(v []*string) *QuickApplyCertificateInput {
	s.San = v
	return s
}

// SetTag sets the Tag field's value.
func (s *QuickApplyCertificateInput) SetTag(v string) *QuickApplyCertificateInput {
	s.Tag = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *QuickApplyCertificateInput) SetTags(v []*TagForQuickApplyCertificateInput) *QuickApplyCertificateInput {
	s.Tags = v
	return s
}

// SetValidationType sets the ValidationType field's value.
func (s *QuickApplyCertificateInput) SetValidationType(v string) *QuickApplyCertificateInput {
	s.ValidationType = &v
	return s
}

type QuickApplyCertificateOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	InstanceId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s QuickApplyCertificateOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s QuickApplyCertificateOutput) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *QuickApplyCertificateOutput) SetInstanceId(v string) *QuickApplyCertificateOutput {
	s.InstanceId = &v
	return s
}

type TagForQuickApplyCertificateInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForQuickApplyCertificateInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForQuickApplyCertificateInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForQuickApplyCertificateInput) SetKey(v string) *TagForQuickApplyCertificateInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForQuickApplyCertificateInput) SetValue(v string) *TagForQuickApplyCertificateInput {
	s.Value = &v
	return s
}

const (
	// EnumOfKeyAlgForQuickApplyCertificateInputRsa is a EnumOfKeyAlgForQuickApplyCertificateInput enum value
	EnumOfKeyAlgForQuickApplyCertificateInputRsa = "rsa"

	// EnumOfKeyAlgForQuickApplyCertificateInputEcc is a EnumOfKeyAlgForQuickApplyCertificateInput enum value
	EnumOfKeyAlgForQuickApplyCertificateInputEcc = "ecc"

	// EnumOfKeyAlgForQuickApplyCertificateInputSm2 is a EnumOfKeyAlgForQuickApplyCertificateInput enum value
	EnumOfKeyAlgForQuickApplyCertificateInputSm2 = "SM2"
)

const (
	// EnumOfValidationTypeForQuickApplyCertificateInputDnsCname is a EnumOfValidationTypeForQuickApplyCertificateInput enum value
	EnumOfValidationTypeForQuickApplyCertificateInputDnsCname = "dns_cname"

	// EnumOfValidationTypeForQuickApplyCertificateInputDnsTxt is a EnumOfValidationTypeForQuickApplyCertificateInput enum value
	EnumOfValidationTypeForQuickApplyCertificateInputDnsTxt = "dns_txt"

	// EnumOfValidationTypeForQuickApplyCertificateInputHttps is a EnumOfValidationTypeForQuickApplyCertificateInput enum value
	EnumOfValidationTypeForQuickApplyCertificateInputHttps = "https"

	// EnumOfValidationTypeForQuickApplyCertificateInputHttp is a EnumOfValidationTypeForQuickApplyCertificateInput enum value
	EnumOfValidationTypeForQuickApplyCertificateInputHttp = "http"
)
