// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package cdn

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeDistrictSummaryCommon = "DescribeDistrictSummary"

// DescribeDistrictSummaryCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeDistrictSummaryCommon operation. The "output" return
// value will be populated with the DescribeDistrictSummaryCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeDistrictSummaryCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeDistrictSummaryCommon Send returns without error.
//
// See DescribeDistrictSummaryCommon for more information on using the DescribeDistrictSummaryCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeDistrictSummaryCommonRequest method.
//    req, resp := client.DescribeDistrictSummaryCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CDN) DescribeDistrictSummaryCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeDistrictSummaryCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeDistrictSummaryCommon API operation for CDN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CDN's
// API operation DescribeDistrictSummaryCommon for usage and error information.
func (c *CDN) DescribeDistrictSummaryCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeDistrictSummaryCommonRequest(input)
	return out, req.Send()
}

// DescribeDistrictSummaryCommonWithContext is the same as DescribeDistrictSummaryCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDistrictSummaryCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CDN) DescribeDistrictSummaryCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeDistrictSummaryCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDistrictSummary = "DescribeDistrictSummary"

// DescribeDistrictSummaryRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeDistrictSummary operation. The "output" return
// value will be populated with the DescribeDistrictSummaryCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeDistrictSummaryCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeDistrictSummaryCommon Send returns without error.
//
// See DescribeDistrictSummary for more information on using the DescribeDistrictSummary
// API call, and error handling.
//
//    // Example sending a request using the DescribeDistrictSummaryRequest method.
//    req, resp := client.DescribeDistrictSummaryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CDN) DescribeDistrictSummaryRequest(input *DescribeDistrictSummaryInput) (req *request.Request, output *DescribeDistrictSummaryOutput) {
	op := &request.Operation{
		Name:       opDescribeDistrictSummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDistrictSummaryInput{}
	}

	output = &DescribeDistrictSummaryOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeDistrictSummary API operation for CDN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CDN's
// API operation DescribeDistrictSummary for usage and error information.
func (c *CDN) DescribeDistrictSummary(input *DescribeDistrictSummaryInput) (*DescribeDistrictSummaryOutput, error) {
	req, out := c.DescribeDistrictSummaryRequest(input)
	return out, req.Send()
}

// DescribeDistrictSummaryWithContext is the same as DescribeDistrictSummary with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDistrictSummary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CDN) DescribeDistrictSummaryWithContext(ctx volcengine.Context, input *DescribeDistrictSummaryInput, opts ...request.Option) (*DescribeDistrictSummaryOutput, error) {
	req, out := c.DescribeDistrictSummaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DescribeDistrictSummaryInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Domain *string `type:"string" json:",omitempty"`

	// EndTime is a required field
	EndTime *int64 `type:"int64" json:",omitempty" required:"true"`

	Interval *string `type:"string" json:",omitempty"`

	IpVersion *string `type:"string" json:",omitempty"`

	Isp *string `type:"string" json:",omitempty"`

	Location *string `type:"string" json:",omitempty"`

	// Metric is a required field
	Metric *string `type:"string" json:",omitempty" required:"true"`

	Project *string `type:"string" json:",omitempty"`

	Protocol *string `type:"string" json:",omitempty"`

	Province *string `type:"string" json:",omitempty"`

	// StartTime is a required field
	StartTime *int64 `type:"int64" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s DescribeDistrictSummaryInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDistrictSummaryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDistrictSummaryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDistrictSummaryInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.Metric == nil {
		invalidParams.Add(request.NewErrParamRequired("Metric"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *DescribeDistrictSummaryInput) SetDomain(v string) *DescribeDistrictSummaryInput {
	s.Domain = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeDistrictSummaryInput) SetEndTime(v int64) *DescribeDistrictSummaryInput {
	s.EndTime = &v
	return s
}

// SetInterval sets the Interval field's value.
func (s *DescribeDistrictSummaryInput) SetInterval(v string) *DescribeDistrictSummaryInput {
	s.Interval = &v
	return s
}

// SetIpVersion sets the IpVersion field's value.
func (s *DescribeDistrictSummaryInput) SetIpVersion(v string) *DescribeDistrictSummaryInput {
	s.IpVersion = &v
	return s
}

// SetIsp sets the Isp field's value.
func (s *DescribeDistrictSummaryInput) SetIsp(v string) *DescribeDistrictSummaryInput {
	s.Isp = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *DescribeDistrictSummaryInput) SetLocation(v string) *DescribeDistrictSummaryInput {
	s.Location = &v
	return s
}

// SetMetric sets the Metric field's value.
func (s *DescribeDistrictSummaryInput) SetMetric(v string) *DescribeDistrictSummaryInput {
	s.Metric = &v
	return s
}

// SetProject sets the Project field's value.
func (s *DescribeDistrictSummaryInput) SetProject(v string) *DescribeDistrictSummaryInput {
	s.Project = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *DescribeDistrictSummaryInput) SetProtocol(v string) *DescribeDistrictSummaryInput {
	s.Protocol = &v
	return s
}

// SetProvince sets the Province field's value.
func (s *DescribeDistrictSummaryInput) SetProvince(v string) *DescribeDistrictSummaryInput {
	s.Province = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeDistrictSummaryInput) SetStartTime(v int64) *DescribeDistrictSummaryInput {
	s.StartTime = &v
	return s
}

type DescribeDistrictSummaryOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	MetricDataList []*MetricDataListForDescribeDistrictSummaryOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s DescribeDistrictSummaryOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDistrictSummaryOutput) GoString() string {
	return s.String()
}

// SetMetricDataList sets the MetricDataList field's value.
func (s *DescribeDistrictSummaryOutput) SetMetricDataList(v []*MetricDataListForDescribeDistrictSummaryOutput) *DescribeDistrictSummaryOutput {
	s.MetricDataList = v
	return s
}

type MetricDataListForDescribeDistrictSummaryOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metric *string `type:"string" json:",omitempty"`

	Value *float64 `type:"double" json:",omitempty"`
}

// String returns the string representation
func (s MetricDataListForDescribeDistrictSummaryOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricDataListForDescribeDistrictSummaryOutput) GoString() string {
	return s.String()
}

// SetMetric sets the Metric field's value.
func (s *MetricDataListForDescribeDistrictSummaryOutput) SetMetric(v string) *MetricDataListForDescribeDistrictSummaryOutput {
	s.Metric = &v
	return s
}

// SetValue sets the Value field's value.
func (s *MetricDataListForDescribeDistrictSummaryOutput) SetValue(v float64) *MetricDataListForDescribeDistrictSummaryOutput {
	s.Value = &v
	return s
}
