// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package bio

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListWorkflowsCommon = "ListWorkflows"

// ListWorkflowsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListWorkflowsCommon operation. The "output" return
// value will be populated with the ListWorkflowsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListWorkflowsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListWorkflowsCommon Send returns without error.
//
// See ListWorkflowsCommon for more information on using the ListWorkflowsCommon
// API call, and error handling.
//
//    // Example sending a request using the ListWorkflowsCommonRequest method.
//    req, resp := client.ListWorkflowsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *BIO) ListWorkflowsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListWorkflowsCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListWorkflowsCommon API operation for BIO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for BIO's
// API operation ListWorkflowsCommon for usage and error information.
func (c *BIO) ListWorkflowsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListWorkflowsCommonRequest(input)
	return out, req.Send()
}

// ListWorkflowsCommonWithContext is the same as ListWorkflowsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkflowsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BIO) ListWorkflowsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListWorkflowsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListWorkflows = "ListWorkflows"

// ListWorkflowsRequest generates a "volcengine/request.Request" representing the
// client's request for the ListWorkflows operation. The "output" return
// value will be populated with the ListWorkflowsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListWorkflowsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListWorkflowsCommon Send returns without error.
//
// See ListWorkflows for more information on using the ListWorkflows
// API call, and error handling.
//
//    // Example sending a request using the ListWorkflowsRequest method.
//    req, resp := client.ListWorkflowsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *BIO) ListWorkflowsRequest(input *ListWorkflowsInput) (req *request.Request, output *ListWorkflowsOutput) {
	op := &request.Operation{
		Name:       opListWorkflows,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListWorkflowsInput{}
	}

	output = &ListWorkflowsOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListWorkflows API operation for BIO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for BIO's
// API operation ListWorkflows for usage and error information.
func (c *BIO) ListWorkflows(input *ListWorkflowsInput) (*ListWorkflowsOutput, error) {
	req, out := c.ListWorkflowsRequest(input)
	return out, req.Send()
}

// ListWorkflowsWithContext is the same as ListWorkflows with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkflows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BIO) ListWorkflowsWithContext(ctx volcengine.Context, input *ListWorkflowsInput, opts ...request.Option) (*ListWorkflowsOutput, error) {
	req, out := c.ListWorkflowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type FilterForListWorkflowsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	IDs []*string `type:"list" json:",omitempty"`

	Keyword *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s FilterForListWorkflowsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FilterForListWorkflowsInput) GoString() string {
	return s.String()
}

// SetIDs sets the IDs field's value.
func (s *FilterForListWorkflowsInput) SetIDs(v []*string) *FilterForListWorkflowsInput {
	s.IDs = v
	return s
}

// SetKeyword sets the Keyword field's value.
func (s *FilterForListWorkflowsInput) SetKeyword(v string) *FilterForListWorkflowsInput {
	s.Keyword = &v
	return s
}

type InputForListWorkflowsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Default *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Optional *bool `type:"boolean" json:",omitempty"`

	ParameterMeta *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s InputForListWorkflowsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s InputForListWorkflowsOutput) GoString() string {
	return s.String()
}

// SetDefault sets the Default field's value.
func (s *InputForListWorkflowsOutput) SetDefault(v string) *InputForListWorkflowsOutput {
	s.Default = &v
	return s
}

// SetName sets the Name field's value.
func (s *InputForListWorkflowsOutput) SetName(v string) *InputForListWorkflowsOutput {
	s.Name = &v
	return s
}

// SetOptional sets the Optional field's value.
func (s *InputForListWorkflowsOutput) SetOptional(v bool) *InputForListWorkflowsOutput {
	s.Optional = &v
	return s
}

// SetParameterMeta sets the ParameterMeta field's value.
func (s *InputForListWorkflowsOutput) SetParameterMeta(v string) *InputForListWorkflowsOutput {
	s.ParameterMeta = &v
	return s
}

// SetType sets the Type field's value.
func (s *InputForListWorkflowsOutput) SetType(v string) *InputForListWorkflowsOutput {
	s.Type = &v
	return s
}

type ItemForListWorkflowsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreateTime *int32 `type:"int32" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	Graph *string `type:"string" json:",omitempty"`

	ID *string `type:"string" json:",omitempty"`

	Inputs []*InputForListWorkflowsOutput `type:"list" json:",omitempty"`

	Language *string `type:"string" json:",omitempty"`

	MainWorkflowPath *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Outputs []*OutputForListWorkflowsOutput `type:"list" json:",omitempty"`

	OwnerName *string `type:"string" json:",omitempty"`

	Source *string `type:"string" json:",omitempty"`

	SourceType *string `type:"string" json:",omitempty" enum:"EnumOfSourceTypeForListWorkflowsOutput"`

	Status *StatusForListWorkflowsOutput `type:"structure" json:",omitempty"`

	Tag *string `type:"string" json:",omitempty"`

	Token *string `type:"string" json:",omitempty"`

	UpdateTime *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ItemForListWorkflowsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ItemForListWorkflowsOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *ItemForListWorkflowsOutput) SetCreateTime(v int32) *ItemForListWorkflowsOutput {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ItemForListWorkflowsOutput) SetDescription(v string) *ItemForListWorkflowsOutput {
	s.Description = &v
	return s
}

// SetGraph sets the Graph field's value.
func (s *ItemForListWorkflowsOutput) SetGraph(v string) *ItemForListWorkflowsOutput {
	s.Graph = &v
	return s
}

// SetID sets the ID field's value.
func (s *ItemForListWorkflowsOutput) SetID(v string) *ItemForListWorkflowsOutput {
	s.ID = &v
	return s
}

// SetInputs sets the Inputs field's value.
func (s *ItemForListWorkflowsOutput) SetInputs(v []*InputForListWorkflowsOutput) *ItemForListWorkflowsOutput {
	s.Inputs = v
	return s
}

// SetLanguage sets the Language field's value.
func (s *ItemForListWorkflowsOutput) SetLanguage(v string) *ItemForListWorkflowsOutput {
	s.Language = &v
	return s
}

// SetMainWorkflowPath sets the MainWorkflowPath field's value.
func (s *ItemForListWorkflowsOutput) SetMainWorkflowPath(v string) *ItemForListWorkflowsOutput {
	s.MainWorkflowPath = &v
	return s
}

// SetName sets the Name field's value.
func (s *ItemForListWorkflowsOutput) SetName(v string) *ItemForListWorkflowsOutput {
	s.Name = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *ItemForListWorkflowsOutput) SetOutputs(v []*OutputForListWorkflowsOutput) *ItemForListWorkflowsOutput {
	s.Outputs = v
	return s
}

// SetOwnerName sets the OwnerName field's value.
func (s *ItemForListWorkflowsOutput) SetOwnerName(v string) *ItemForListWorkflowsOutput {
	s.OwnerName = &v
	return s
}

// SetSource sets the Source field's value.
func (s *ItemForListWorkflowsOutput) SetSource(v string) *ItemForListWorkflowsOutput {
	s.Source = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *ItemForListWorkflowsOutput) SetSourceType(v string) *ItemForListWorkflowsOutput {
	s.SourceType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ItemForListWorkflowsOutput) SetStatus(v *StatusForListWorkflowsOutput) *ItemForListWorkflowsOutput {
	s.Status = v
	return s
}

// SetTag sets the Tag field's value.
func (s *ItemForListWorkflowsOutput) SetTag(v string) *ItemForListWorkflowsOutput {
	s.Tag = &v
	return s
}

// SetToken sets the Token field's value.
func (s *ItemForListWorkflowsOutput) SetToken(v string) *ItemForListWorkflowsOutput {
	s.Token = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ItemForListWorkflowsOutput) SetUpdateTime(v string) *ItemForListWorkflowsOutput {
	s.UpdateTime = &v
	return s
}

type ListWorkflowsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Filter *FilterForListWorkflowsInput `type:"structure" json:",omitempty"`

	PageNumber *int32 `min:"1" type:"int32" json:",omitempty"`

	PageSize *int32 `max:"100" type:"int32" json:",omitempty"`

	SortBy *string `type:"string" json:",omitempty" enum:"EnumOfSortByForListWorkflowsInput"`

	SortOrder *string `type:"string" json:",omitempty" enum:"EnumOfSortOrderForListWorkflowsInput"`

	// WorkspaceID is a required field
	WorkspaceID *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s ListWorkflowsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWorkflowsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorkflowsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWorkflowsInput"}
	if s.PageNumber != nil && *s.PageNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageNumber", 1))
	}
	if s.PageSize != nil && *s.PageSize > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 100))
	}
	if s.WorkspaceID == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListWorkflowsInput) SetFilter(v *FilterForListWorkflowsInput) *ListWorkflowsInput {
	s.Filter = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListWorkflowsInput) SetPageNumber(v int32) *ListWorkflowsInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListWorkflowsInput) SetPageSize(v int32) *ListWorkflowsInput {
	s.PageSize = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListWorkflowsInput) SetSortBy(v string) *ListWorkflowsInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListWorkflowsInput) SetSortOrder(v string) *ListWorkflowsInput {
	s.SortOrder = &v
	return s
}

// SetWorkspaceID sets the WorkspaceID field's value.
func (s *ListWorkflowsInput) SetWorkspaceID(v string) *ListWorkflowsInput {
	s.WorkspaceID = &v
	return s
}

type ListWorkflowsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Items []*ItemForListWorkflowsOutput `type:"list" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ListWorkflowsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWorkflowsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListWorkflowsOutput) SetItems(v []*ItemForListWorkflowsOutput) *ListWorkflowsOutput {
	s.Items = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListWorkflowsOutput) SetPageNumber(v int32) *ListWorkflowsOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListWorkflowsOutput) SetPageSize(v int32) *ListWorkflowsOutput {
	s.PageSize = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListWorkflowsOutput) SetTotalCount(v int32) *ListWorkflowsOutput {
	s.TotalCount = &v
	return s
}

type OutputForListWorkflowsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Default *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Optional *bool `type:"boolean" json:",omitempty"`

	ParameterMeta *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s OutputForListWorkflowsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputForListWorkflowsOutput) GoString() string {
	return s.String()
}

// SetDefault sets the Default field's value.
func (s *OutputForListWorkflowsOutput) SetDefault(v string) *OutputForListWorkflowsOutput {
	s.Default = &v
	return s
}

// SetName sets the Name field's value.
func (s *OutputForListWorkflowsOutput) SetName(v string) *OutputForListWorkflowsOutput {
	s.Name = &v
	return s
}

// SetOptional sets the Optional field's value.
func (s *OutputForListWorkflowsOutput) SetOptional(v bool) *OutputForListWorkflowsOutput {
	s.Optional = &v
	return s
}

// SetParameterMeta sets the ParameterMeta field's value.
func (s *OutputForListWorkflowsOutput) SetParameterMeta(v string) *OutputForListWorkflowsOutput {
	s.ParameterMeta = &v
	return s
}

// SetType sets the Type field's value.
func (s *OutputForListWorkflowsOutput) SetType(v string) *OutputForListWorkflowsOutput {
	s.Type = &v
	return s
}

type StatusForListWorkflowsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Message *string `type:"string" json:",omitempty"`

	Phase *string `type:"string" json:",omitempty" enum:"EnumOfPhaseForListWorkflowsOutput"`
}

// String returns the string representation
func (s StatusForListWorkflowsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusForListWorkflowsOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *StatusForListWorkflowsOutput) SetMessage(v string) *StatusForListWorkflowsOutput {
	s.Message = &v
	return s
}

// SetPhase sets the Phase field's value.
func (s *StatusForListWorkflowsOutput) SetPhase(v string) *StatusForListWorkflowsOutput {
	s.Phase = &v
	return s
}

const (
	// EnumOfPhaseForListWorkflowsOutputImporting is a EnumOfPhaseForListWorkflowsOutput enum value
	EnumOfPhaseForListWorkflowsOutputImporting = "Importing"

	// EnumOfPhaseForListWorkflowsOutputSucceeded is a EnumOfPhaseForListWorkflowsOutput enum value
	EnumOfPhaseForListWorkflowsOutputSucceeded = "Succeeded"

	// EnumOfPhaseForListWorkflowsOutputFailed is a EnumOfPhaseForListWorkflowsOutput enum value
	EnumOfPhaseForListWorkflowsOutputFailed = "Failed"
)

const (
	// EnumOfSortByForListWorkflowsInputName is a EnumOfSortByForListWorkflowsInput enum value
	EnumOfSortByForListWorkflowsInputName = "Name"

	// EnumOfSortByForListWorkflowsInputCreateTime is a EnumOfSortByForListWorkflowsInput enum value
	EnumOfSortByForListWorkflowsInputCreateTime = "CreateTime"

	// EnumOfSortByForListWorkflowsInputUpdateTime is a EnumOfSortByForListWorkflowsInput enum value
	EnumOfSortByForListWorkflowsInputUpdateTime = "UpdateTime"

	// EnumOfSortByForListWorkflowsInputId is a EnumOfSortByForListWorkflowsInput enum value
	EnumOfSortByForListWorkflowsInputId = "ID"
)

const (
	// EnumOfSortOrderForListWorkflowsInputDesc is a EnumOfSortOrderForListWorkflowsInput enum value
	EnumOfSortOrderForListWorkflowsInputDesc = "Desc"

	// EnumOfSortOrderForListWorkflowsInputAsc is a EnumOfSortOrderForListWorkflowsInput enum value
	EnumOfSortOrderForListWorkflowsInputAsc = "Asc"
)

const (
	// EnumOfSourceTypeForListWorkflowsOutputGit is a EnumOfSourceTypeForListWorkflowsOutput enum value
	EnumOfSourceTypeForListWorkflowsOutputGit = "git"

	// EnumOfSourceTypeForListWorkflowsOutputDockstore is a EnumOfSourceTypeForListWorkflowsOutput enum value
	EnumOfSourceTypeForListWorkflowsOutputDockstore = "dockstore"

	// EnumOfSourceTypeForListWorkflowsOutputFile is a EnumOfSourceTypeForListWorkflowsOutput enum value
	EnumOfSourceTypeForListWorkflowsOutputFile = "file"

	// EnumOfSourceTypeForListWorkflowsOutputDev is a EnumOfSourceTypeForListWorkflowsOutput enum value
	EnumOfSourceTypeForListWorkflowsOutputDev = "dev"
)
