// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package bio

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListSubmissionsCommon = "ListSubmissions"

// ListSubmissionsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListSubmissionsCommon operation. The "output" return
// value will be populated with the ListSubmissionsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListSubmissionsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListSubmissionsCommon Send returns without error.
//
// See ListSubmissionsCommon for more information on using the ListSubmissionsCommon
// API call, and error handling.
//
//    // Example sending a request using the ListSubmissionsCommonRequest method.
//    req, resp := client.ListSubmissionsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *BIO) ListSubmissionsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListSubmissionsCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListSubmissionsCommon API operation for BIO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for BIO's
// API operation ListSubmissionsCommon for usage and error information.
func (c *BIO) ListSubmissionsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListSubmissionsCommonRequest(input)
	return out, req.Send()
}

// ListSubmissionsCommonWithContext is the same as ListSubmissionsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListSubmissionsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BIO) ListSubmissionsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListSubmissionsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSubmissions = "ListSubmissions"

// ListSubmissionsRequest generates a "volcengine/request.Request" representing the
// client's request for the ListSubmissions operation. The "output" return
// value will be populated with the ListSubmissionsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListSubmissionsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListSubmissionsCommon Send returns without error.
//
// See ListSubmissions for more information on using the ListSubmissions
// API call, and error handling.
//
//    // Example sending a request using the ListSubmissionsRequest method.
//    req, resp := client.ListSubmissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *BIO) ListSubmissionsRequest(input *ListSubmissionsInput) (req *request.Request, output *ListSubmissionsOutput) {
	op := &request.Operation{
		Name:       opListSubmissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListSubmissionsInput{}
	}

	output = &ListSubmissionsOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListSubmissions API operation for BIO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for BIO's
// API operation ListSubmissions for usage and error information.
func (c *BIO) ListSubmissions(input *ListSubmissionsInput) (*ListSubmissionsOutput, error) {
	req, out := c.ListSubmissionsRequest(input)
	return out, req.Send()
}

// ListSubmissionsWithContext is the same as ListSubmissions with the addition of
// the ability to pass a context and additional request options.
//
// See ListSubmissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BIO) ListSubmissionsWithContext(ctx volcengine.Context, input *ListSubmissionsInput, opts ...request.Option) (*ListSubmissionsOutput, error) {
	req, out := c.ListSubmissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DataEntityForListSubmissionsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ID *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	RowIDs []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s DataEntityForListSubmissionsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DataEntityForListSubmissionsOutput) GoString() string {
	return s.String()
}

// SetID sets the ID field's value.
func (s *DataEntityForListSubmissionsOutput) SetID(v string) *DataEntityForListSubmissionsOutput {
	s.ID = &v
	return s
}

// SetName sets the Name field's value.
func (s *DataEntityForListSubmissionsOutput) SetName(v string) *DataEntityForListSubmissionsOutput {
	s.Name = &v
	return s
}

// SetRowIDs sets the RowIDs field's value.
func (s *DataEntityForListSubmissionsOutput) SetRowIDs(v []*string) *DataEntityForListSubmissionsOutput {
	s.RowIDs = v
	return s
}

type ExposedOptionsForListSubmissionsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AAIPassport *string `type:"string" json:",omitempty"`

	ExecutionRootDir *string `type:"string" json:",omitempty"`

	MountTOS *bool `type:"boolean" json:",omitempty"`

	ReadFromCache *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s ExposedOptionsForListSubmissionsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ExposedOptionsForListSubmissionsOutput) GoString() string {
	return s.String()
}

// SetAAIPassport sets the AAIPassport field's value.
func (s *ExposedOptionsForListSubmissionsOutput) SetAAIPassport(v string) *ExposedOptionsForListSubmissionsOutput {
	s.AAIPassport = &v
	return s
}

// SetExecutionRootDir sets the ExecutionRootDir field's value.
func (s *ExposedOptionsForListSubmissionsOutput) SetExecutionRootDir(v string) *ExposedOptionsForListSubmissionsOutput {
	s.ExecutionRootDir = &v
	return s
}

// SetMountTOS sets the MountTOS field's value.
func (s *ExposedOptionsForListSubmissionsOutput) SetMountTOS(v bool) *ExposedOptionsForListSubmissionsOutput {
	s.MountTOS = &v
	return s
}

// SetReadFromCache sets the ReadFromCache field's value.
func (s *ExposedOptionsForListSubmissionsOutput) SetReadFromCache(v bool) *ExposedOptionsForListSubmissionsOutput {
	s.ReadFromCache = &v
	return s
}

type FilterForListSubmissionsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ClusterID *string `type:"string" json:",omitempty"`

	DisplayLevel *string `type:"string" json:",omitempty"`

	IDs []*string `type:"list" json:",omitempty"`

	Keyword *string `type:"string" json:",omitempty"`

	Status []*string `type:"list" json:",omitempty"`

	WorkflowID *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s FilterForListSubmissionsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FilterForListSubmissionsInput) GoString() string {
	return s.String()
}

// SetClusterID sets the ClusterID field's value.
func (s *FilterForListSubmissionsInput) SetClusterID(v string) *FilterForListSubmissionsInput {
	s.ClusterID = &v
	return s
}

// SetDisplayLevel sets the DisplayLevel field's value.
func (s *FilterForListSubmissionsInput) SetDisplayLevel(v string) *FilterForListSubmissionsInput {
	s.DisplayLevel = &v
	return s
}

// SetIDs sets the IDs field's value.
func (s *FilterForListSubmissionsInput) SetIDs(v []*string) *FilterForListSubmissionsInput {
	s.IDs = v
	return s
}

// SetKeyword sets the Keyword field's value.
func (s *FilterForListSubmissionsInput) SetKeyword(v string) *FilterForListSubmissionsInput {
	s.Keyword = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *FilterForListSubmissionsInput) SetStatus(v []*string) *FilterForListSubmissionsInput {
	s.Status = v
	return s
}

// SetWorkflowID sets the WorkflowID field's value.
func (s *FilterForListSubmissionsInput) SetWorkflowID(v string) *FilterForListSubmissionsInput {
	s.WorkflowID = &v
	return s
}

type ItemForListSubmissionsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ClusterID *string `type:"string" json:",omitempty"`

	ClusterType *string `type:"string" json:",omitempty"`

	DataEntity *DataEntityForListSubmissionsOutput `type:"structure" json:",omitempty"`

	DataModelID *string `type:"string" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	Duration *int32 `type:"int32" json:",omitempty"`

	ExposedOptions *ExposedOptionsForListSubmissionsOutput `type:"structure" json:",omitempty"`

	FinishTime *int32 `type:"int32" json:",omitempty"`

	ID *string `type:"string" json:",omitempty"`

	Inputs *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Outputs *string `type:"string" json:",omitempty"`

	OwnerName *string `type:"string" json:",omitempty"`

	RunStatus *RunStatusForListSubmissionsOutput `type:"structure" json:",omitempty"`

	StartTime *int32 `type:"int32" json:",omitempty"`

	Status *string `type:"string" json:",omitempty" enum:"EnumOfStatusForListSubmissionsOutput"`

	WorkflowID *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ItemForListSubmissionsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ItemForListSubmissionsOutput) GoString() string {
	return s.String()
}

// SetClusterID sets the ClusterID field's value.
func (s *ItemForListSubmissionsOutput) SetClusterID(v string) *ItemForListSubmissionsOutput {
	s.ClusterID = &v
	return s
}

// SetClusterType sets the ClusterType field's value.
func (s *ItemForListSubmissionsOutput) SetClusterType(v string) *ItemForListSubmissionsOutput {
	s.ClusterType = &v
	return s
}

// SetDataEntity sets the DataEntity field's value.
func (s *ItemForListSubmissionsOutput) SetDataEntity(v *DataEntityForListSubmissionsOutput) *ItemForListSubmissionsOutput {
	s.DataEntity = v
	return s
}

// SetDataModelID sets the DataModelID field's value.
func (s *ItemForListSubmissionsOutput) SetDataModelID(v string) *ItemForListSubmissionsOutput {
	s.DataModelID = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ItemForListSubmissionsOutput) SetDescription(v string) *ItemForListSubmissionsOutput {
	s.Description = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *ItemForListSubmissionsOutput) SetDuration(v int32) *ItemForListSubmissionsOutput {
	s.Duration = &v
	return s
}

// SetExposedOptions sets the ExposedOptions field's value.
func (s *ItemForListSubmissionsOutput) SetExposedOptions(v *ExposedOptionsForListSubmissionsOutput) *ItemForListSubmissionsOutput {
	s.ExposedOptions = v
	return s
}

// SetFinishTime sets the FinishTime field's value.
func (s *ItemForListSubmissionsOutput) SetFinishTime(v int32) *ItemForListSubmissionsOutput {
	s.FinishTime = &v
	return s
}

// SetID sets the ID field's value.
func (s *ItemForListSubmissionsOutput) SetID(v string) *ItemForListSubmissionsOutput {
	s.ID = &v
	return s
}

// SetInputs sets the Inputs field's value.
func (s *ItemForListSubmissionsOutput) SetInputs(v string) *ItemForListSubmissionsOutput {
	s.Inputs = &v
	return s
}

// SetName sets the Name field's value.
func (s *ItemForListSubmissionsOutput) SetName(v string) *ItemForListSubmissionsOutput {
	s.Name = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *ItemForListSubmissionsOutput) SetOutputs(v string) *ItemForListSubmissionsOutput {
	s.Outputs = &v
	return s
}

// SetOwnerName sets the OwnerName field's value.
func (s *ItemForListSubmissionsOutput) SetOwnerName(v string) *ItemForListSubmissionsOutput {
	s.OwnerName = &v
	return s
}

// SetRunStatus sets the RunStatus field's value.
func (s *ItemForListSubmissionsOutput) SetRunStatus(v *RunStatusForListSubmissionsOutput) *ItemForListSubmissionsOutput {
	s.RunStatus = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ItemForListSubmissionsOutput) SetStartTime(v int32) *ItemForListSubmissionsOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ItemForListSubmissionsOutput) SetStatus(v string) *ItemForListSubmissionsOutput {
	s.Status = &v
	return s
}

// SetWorkflowID sets the WorkflowID field's value.
func (s *ItemForListSubmissionsOutput) SetWorkflowID(v string) *ItemForListSubmissionsOutput {
	s.WorkflowID = &v
	return s
}

type ListSubmissionsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Filter *FilterForListSubmissionsInput `type:"structure" json:",omitempty"`

	PageNumber *int32 `min:"1" type:"int32" json:",omitempty"`

	PageSize *int32 `max:"100" type:"int32" json:",omitempty"`

	// WorkspaceID is a required field
	WorkspaceID *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s ListSubmissionsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSubmissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSubmissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSubmissionsInput"}
	if s.PageNumber != nil && *s.PageNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageNumber", 1))
	}
	if s.PageSize != nil && *s.PageSize > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 100))
	}
	if s.WorkspaceID == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListSubmissionsInput) SetFilter(v *FilterForListSubmissionsInput) *ListSubmissionsInput {
	s.Filter = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListSubmissionsInput) SetPageNumber(v int32) *ListSubmissionsInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListSubmissionsInput) SetPageSize(v int32) *ListSubmissionsInput {
	s.PageSize = &v
	return s
}

// SetWorkspaceID sets the WorkspaceID field's value.
func (s *ListSubmissionsInput) SetWorkspaceID(v string) *ListSubmissionsInput {
	s.WorkspaceID = &v
	return s
}

type ListSubmissionsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Items []*ItemForListSubmissionsOutput `type:"list" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ListSubmissionsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSubmissionsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListSubmissionsOutput) SetItems(v []*ItemForListSubmissionsOutput) *ListSubmissionsOutput {
	s.Items = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListSubmissionsOutput) SetPageNumber(v int32) *ListSubmissionsOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListSubmissionsOutput) SetPageSize(v int32) *ListSubmissionsOutput {
	s.PageSize = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListSubmissionsOutput) SetTotalCount(v int32) *ListSubmissionsOutput {
	s.TotalCount = &v
	return s
}

type RunStatusForListSubmissionsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Cancelled *int32 `type:"int32" json:",omitempty"`

	Cancelling *string `type:"string" json:",omitempty"`

	Count *int32 `type:"int32" json:",omitempty"`

	Failed *int32 `type:"int32" json:",omitempty"`

	Pending *int32 `type:"int32" json:",omitempty"`

	Running *int32 `type:"int32" json:",omitempty"`

	Succeeded *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s RunStatusForListSubmissionsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RunStatusForListSubmissionsOutput) GoString() string {
	return s.String()
}

// SetCancelled sets the Cancelled field's value.
func (s *RunStatusForListSubmissionsOutput) SetCancelled(v int32) *RunStatusForListSubmissionsOutput {
	s.Cancelled = &v
	return s
}

// SetCancelling sets the Cancelling field's value.
func (s *RunStatusForListSubmissionsOutput) SetCancelling(v string) *RunStatusForListSubmissionsOutput {
	s.Cancelling = &v
	return s
}

// SetCount sets the Count field's value.
func (s *RunStatusForListSubmissionsOutput) SetCount(v int32) *RunStatusForListSubmissionsOutput {
	s.Count = &v
	return s
}

// SetFailed sets the Failed field's value.
func (s *RunStatusForListSubmissionsOutput) SetFailed(v int32) *RunStatusForListSubmissionsOutput {
	s.Failed = &v
	return s
}

// SetPending sets the Pending field's value.
func (s *RunStatusForListSubmissionsOutput) SetPending(v int32) *RunStatusForListSubmissionsOutput {
	s.Pending = &v
	return s
}

// SetRunning sets the Running field's value.
func (s *RunStatusForListSubmissionsOutput) SetRunning(v int32) *RunStatusForListSubmissionsOutput {
	s.Running = &v
	return s
}

// SetSucceeded sets the Succeeded field's value.
func (s *RunStatusForListSubmissionsOutput) SetSucceeded(v int32) *RunStatusForListSubmissionsOutput {
	s.Succeeded = &v
	return s
}

const (
	// EnumOfStatusForListSubmissionsOutputSucceeded is a EnumOfStatusForListSubmissionsOutput enum value
	EnumOfStatusForListSubmissionsOutputSucceeded = "Succeeded"

	// EnumOfStatusForListSubmissionsOutputFailed is a EnumOfStatusForListSubmissionsOutput enum value
	EnumOfStatusForListSubmissionsOutputFailed = "Failed"

	// EnumOfStatusForListSubmissionsOutputRunning is a EnumOfStatusForListSubmissionsOutput enum value
	EnumOfStatusForListSubmissionsOutputRunning = "Running"

	// EnumOfStatusForListSubmissionsOutputCancelled is a EnumOfStatusForListSubmissionsOutput enum value
	EnumOfStatusForListSubmissionsOutputCancelled = "Cancelled"

	// EnumOfStatusForListSubmissionsOutputCancelling is a EnumOfStatusForListSubmissionsOutput enum value
	EnumOfStatusForListSubmissionsOutputCancelling = "Cancelling"
)
