// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package bio

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListRunsCommon = "ListRuns"

// ListRunsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListRunsCommon operation. The "output" return
// value will be populated with the ListRunsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListRunsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListRunsCommon Send returns without error.
//
// See ListRunsCommon for more information on using the ListRunsCommon
// API call, and error handling.
//
//    // Example sending a request using the ListRunsCommonRequest method.
//    req, resp := client.ListRunsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *BIO) ListRunsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListRunsCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListRunsCommon API operation for BIO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for BIO's
// API operation ListRunsCommon for usage and error information.
func (c *BIO) ListRunsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListRunsCommonRequest(input)
	return out, req.Send()
}

// ListRunsCommonWithContext is the same as ListRunsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListRunsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BIO) ListRunsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListRunsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRuns = "ListRuns"

// ListRunsRequest generates a "volcengine/request.Request" representing the
// client's request for the ListRuns operation. The "output" return
// value will be populated with the ListRunsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListRunsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListRunsCommon Send returns without error.
//
// See ListRuns for more information on using the ListRuns
// API call, and error handling.
//
//    // Example sending a request using the ListRunsRequest method.
//    req, resp := client.ListRunsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *BIO) ListRunsRequest(input *ListRunsInput) (req *request.Request, output *ListRunsOutput) {
	op := &request.Operation{
		Name:       opListRuns,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRunsInput{}
	}

	output = &ListRunsOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListRuns API operation for BIO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for BIO's
// API operation ListRuns for usage and error information.
func (c *BIO) ListRuns(input *ListRunsInput) (*ListRunsOutput, error) {
	req, out := c.ListRunsRequest(input)
	return out, req.Send()
}

// ListRunsWithContext is the same as ListRuns with the addition of
// the ability to pass a context and additional request options.
//
// See ListRuns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BIO) ListRunsWithContext(ctx volcengine.Context, input *ListRunsInput, opts ...request.Option) (*ListRunsOutput, error) {
	req, out := c.ListRunsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type FilterForListRunsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	IDs []*string `type:"list" json:",omitempty"`

	Keyword *string `type:"string" json:",omitempty"`

	Status []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s FilterForListRunsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FilterForListRunsInput) GoString() string {
	return s.String()
}

// SetIDs sets the IDs field's value.
func (s *FilterForListRunsInput) SetIDs(v []*string) *FilterForListRunsInput {
	s.IDs = v
	return s
}

// SetKeyword sets the Keyword field's value.
func (s *FilterForListRunsInput) SetKeyword(v string) *FilterForListRunsInput {
	s.Keyword = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *FilterForListRunsInput) SetStatus(v []*string) *FilterForListRunsInput {
	s.Status = v
	return s
}

type ItemForListRunsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DataEntityRowID *string `type:"string" json:",omitempty"`

	Duration *int32 `type:"int32" json:",omitempty"`

	EngineRunID *string `type:"string" json:",omitempty"`

	EngineWorkflowName *string `type:"string" json:",omitempty"`

	FinishTime *int32 `type:"int32" json:",omitempty"`

	ID *string `type:"string" json:",omitempty"`

	Inputs *string `type:"string" json:",omitempty"`

	Log *string `type:"string" json:",omitempty"`

	Message *string `type:"string" json:",omitempty"`

	Outputs *string `type:"string" json:",omitempty"`

	StartTime *int32 `type:"int32" json:",omitempty"`

	Status *string `type:"string" json:",omitempty" enum:"EnumOfStatusForListRunsOutput"`

	SubmissionID *string `type:"string" json:",omitempty"`

	TaskStatus *TaskStatusForListRunsOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ItemForListRunsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ItemForListRunsOutput) GoString() string {
	return s.String()
}

// SetDataEntityRowID sets the DataEntityRowID field's value.
func (s *ItemForListRunsOutput) SetDataEntityRowID(v string) *ItemForListRunsOutput {
	s.DataEntityRowID = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *ItemForListRunsOutput) SetDuration(v int32) *ItemForListRunsOutput {
	s.Duration = &v
	return s
}

// SetEngineRunID sets the EngineRunID field's value.
func (s *ItemForListRunsOutput) SetEngineRunID(v string) *ItemForListRunsOutput {
	s.EngineRunID = &v
	return s
}

// SetEngineWorkflowName sets the EngineWorkflowName field's value.
func (s *ItemForListRunsOutput) SetEngineWorkflowName(v string) *ItemForListRunsOutput {
	s.EngineWorkflowName = &v
	return s
}

// SetFinishTime sets the FinishTime field's value.
func (s *ItemForListRunsOutput) SetFinishTime(v int32) *ItemForListRunsOutput {
	s.FinishTime = &v
	return s
}

// SetID sets the ID field's value.
func (s *ItemForListRunsOutput) SetID(v string) *ItemForListRunsOutput {
	s.ID = &v
	return s
}

// SetInputs sets the Inputs field's value.
func (s *ItemForListRunsOutput) SetInputs(v string) *ItemForListRunsOutput {
	s.Inputs = &v
	return s
}

// SetLog sets the Log field's value.
func (s *ItemForListRunsOutput) SetLog(v string) *ItemForListRunsOutput {
	s.Log = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ItemForListRunsOutput) SetMessage(v string) *ItemForListRunsOutput {
	s.Message = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *ItemForListRunsOutput) SetOutputs(v string) *ItemForListRunsOutput {
	s.Outputs = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ItemForListRunsOutput) SetStartTime(v int32) *ItemForListRunsOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ItemForListRunsOutput) SetStatus(v string) *ItemForListRunsOutput {
	s.Status = &v
	return s
}

// SetSubmissionID sets the SubmissionID field's value.
func (s *ItemForListRunsOutput) SetSubmissionID(v string) *ItemForListRunsOutput {
	s.SubmissionID = &v
	return s
}

// SetTaskStatus sets the TaskStatus field's value.
func (s *ItemForListRunsOutput) SetTaskStatus(v *TaskStatusForListRunsOutput) *ItemForListRunsOutput {
	s.TaskStatus = v
	return s
}

type ListRunsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Filter *FilterForListRunsInput `type:"structure" json:",omitempty"`

	PageNumber *int32 `min:"1" type:"int32" json:",omitempty"`

	PageSize *int32 `max:"100" type:"int32" json:",omitempty"`

	// SubmissionID is a required field
	SubmissionID *string `type:"string" json:",omitempty" required:"true"`

	// WorkspaceID is a required field
	WorkspaceID *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s ListRunsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRunsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRunsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRunsInput"}
	if s.PageNumber != nil && *s.PageNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageNumber", 1))
	}
	if s.PageSize != nil && *s.PageSize > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 100))
	}
	if s.SubmissionID == nil {
		invalidParams.Add(request.NewErrParamRequired("SubmissionID"))
	}
	if s.WorkspaceID == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListRunsInput) SetFilter(v *FilterForListRunsInput) *ListRunsInput {
	s.Filter = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListRunsInput) SetPageNumber(v int32) *ListRunsInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListRunsInput) SetPageSize(v int32) *ListRunsInput {
	s.PageSize = &v
	return s
}

// SetSubmissionID sets the SubmissionID field's value.
func (s *ListRunsInput) SetSubmissionID(v string) *ListRunsInput {
	s.SubmissionID = &v
	return s
}

// SetWorkspaceID sets the WorkspaceID field's value.
func (s *ListRunsInput) SetWorkspaceID(v string) *ListRunsInput {
	s.WorkspaceID = &v
	return s
}

type ListRunsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Items []*ItemForListRunsOutput `type:"list" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ListRunsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRunsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListRunsOutput) SetItems(v []*ItemForListRunsOutput) *ListRunsOutput {
	s.Items = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListRunsOutput) SetPageNumber(v int32) *ListRunsOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListRunsOutput) SetPageSize(v int32) *ListRunsOutput {
	s.PageSize = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListRunsOutput) SetTotalCount(v int32) *ListRunsOutput {
	s.TotalCount = &v
	return s
}

type TaskStatusForListRunsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Cancelled *int32 `type:"int32" json:",omitempty"`

	Count *int32 `type:"int32" json:",omitempty"`

	Failed *int32 `type:"int32" json:",omitempty"`

	Initializing *int32 `type:"int32" json:",omitempty"`

	Queued *int32 `type:"int32" json:",omitempty"`

	Running *int32 `type:"int32" json:",omitempty"`

	Succeeded *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s TaskStatusForListRunsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TaskStatusForListRunsOutput) GoString() string {
	return s.String()
}

// SetCancelled sets the Cancelled field's value.
func (s *TaskStatusForListRunsOutput) SetCancelled(v int32) *TaskStatusForListRunsOutput {
	s.Cancelled = &v
	return s
}

// SetCount sets the Count field's value.
func (s *TaskStatusForListRunsOutput) SetCount(v int32) *TaskStatusForListRunsOutput {
	s.Count = &v
	return s
}

// SetFailed sets the Failed field's value.
func (s *TaskStatusForListRunsOutput) SetFailed(v int32) *TaskStatusForListRunsOutput {
	s.Failed = &v
	return s
}

// SetInitializing sets the Initializing field's value.
func (s *TaskStatusForListRunsOutput) SetInitializing(v int32) *TaskStatusForListRunsOutput {
	s.Initializing = &v
	return s
}

// SetQueued sets the Queued field's value.
func (s *TaskStatusForListRunsOutput) SetQueued(v int32) *TaskStatusForListRunsOutput {
	s.Queued = &v
	return s
}

// SetRunning sets the Running field's value.
func (s *TaskStatusForListRunsOutput) SetRunning(v int32) *TaskStatusForListRunsOutput {
	s.Running = &v
	return s
}

// SetSucceeded sets the Succeeded field's value.
func (s *TaskStatusForListRunsOutput) SetSucceeded(v int32) *TaskStatusForListRunsOutput {
	s.Succeeded = &v
	return s
}

const (
	// EnumOfStatusForListRunsOutputSucceeded is a EnumOfStatusForListRunsOutput enum value
	EnumOfStatusForListRunsOutputSucceeded = "Succeeded"

	// EnumOfStatusForListRunsOutputFailed is a EnumOfStatusForListRunsOutput enum value
	EnumOfStatusForListRunsOutputFailed = "Failed"

	// EnumOfStatusForListRunsOutputRunning is a EnumOfStatusForListRunsOutput enum value
	EnumOfStatusForListRunsOutputRunning = "Running"

	// EnumOfStatusForListRunsOutputPending is a EnumOfStatusForListRunsOutput enum value
	EnumOfStatusForListRunsOutputPending = "Pending"

	// EnumOfStatusForListRunsOutputCancelling is a EnumOfStatusForListRunsOutput enum value
	EnumOfStatusForListRunsOutputCancelling = "Cancelling"

	// EnumOfStatusForListRunsOutputCancelled is a EnumOfStatusForListRunsOutput enum value
	EnumOfStatusForListRunsOutputCancelled = "Cancelled"
)

const (
	// EnumOfStatusListForListRunsInputPending is a EnumOfStatusListForListRunsInput enum value
	EnumOfStatusListForListRunsInputPending = "Pending"

	// EnumOfStatusListForListRunsInputRunning is a EnumOfStatusListForListRunsInput enum value
	EnumOfStatusListForListRunsInputRunning = "Running"

	// EnumOfStatusListForListRunsInputFailed is a EnumOfStatusListForListRunsInput enum value
	EnumOfStatusListForListRunsInputFailed = "Failed"

	// EnumOfStatusListForListRunsInputSucceeded is a EnumOfStatusListForListRunsInput enum value
	EnumOfStatusListForListRunsInputSucceeded = "Succeeded"

	// EnumOfStatusListForListRunsInputCancelling is a EnumOfStatusListForListRunsInput enum value
	EnumOfStatusListForListRunsInputCancelling = "Cancelling"

	// EnumOfStatusListForListRunsInputCancelled is a EnumOfStatusListForListRunsInput enum value
	EnumOfStatusListForListRunsInputCancelled = "Cancelled"
)
