// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package bio

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListNotebookServersCommon = "ListNotebookServers"

// ListNotebookServersCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListNotebookServersCommon operation. The "output" return
// value will be populated with the ListNotebookServersCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListNotebookServersCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListNotebookServersCommon Send returns without error.
//
// See ListNotebookServersCommon for more information on using the ListNotebookServersCommon
// API call, and error handling.
//
//    // Example sending a request using the ListNotebookServersCommonRequest method.
//    req, resp := client.ListNotebookServersCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *BIO) ListNotebookServersCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListNotebookServersCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListNotebookServersCommon API operation for BIO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for BIO's
// API operation ListNotebookServersCommon for usage and error information.
func (c *BIO) ListNotebookServersCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListNotebookServersCommonRequest(input)
	return out, req.Send()
}

// ListNotebookServersCommonWithContext is the same as ListNotebookServersCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListNotebookServersCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BIO) ListNotebookServersCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListNotebookServersCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListNotebookServers = "ListNotebookServers"

// ListNotebookServersRequest generates a "volcengine/request.Request" representing the
// client's request for the ListNotebookServers operation. The "output" return
// value will be populated with the ListNotebookServersCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListNotebookServersCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListNotebookServersCommon Send returns without error.
//
// See ListNotebookServers for more information on using the ListNotebookServers
// API call, and error handling.
//
//    // Example sending a request using the ListNotebookServersRequest method.
//    req, resp := client.ListNotebookServersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *BIO) ListNotebookServersRequest(input *ListNotebookServersInput) (req *request.Request, output *ListNotebookServersOutput) {
	op := &request.Operation{
		Name:       opListNotebookServers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListNotebookServersInput{}
	}

	output = &ListNotebookServersOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListNotebookServers API operation for BIO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for BIO's
// API operation ListNotebookServers for usage and error information.
func (c *BIO) ListNotebookServers(input *ListNotebookServersInput) (*ListNotebookServersOutput, error) {
	req, out := c.ListNotebookServersRequest(input)
	return out, req.Send()
}

// ListNotebookServersWithContext is the same as ListNotebookServers with the addition of
// the ability to pass a context and additional request options.
//
// See ListNotebookServers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BIO) ListNotebookServersWithContext(ctx volcengine.Context, input *ListNotebookServersInput, opts ...request.Option) (*ListNotebookServersOutput, error) {
	req, out := c.ListNotebookServersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type FilterForListNotebookServersInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Status []*string `type:"list" json:",omitempty"`

	UserID *int32 `type:"int32" json:",omitempty"`

	WorkspaceID *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s FilterForListNotebookServersInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FilterForListNotebookServersInput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *FilterForListNotebookServersInput) SetStatus(v []*string) *FilterForListNotebookServersInput {
	s.Status = v
	return s
}

// SetUserID sets the UserID field's value.
func (s *FilterForListNotebookServersInput) SetUserID(v int32) *FilterForListNotebookServersInput {
	s.UserID = &v
	return s
}

// SetWorkspaceID sets the WorkspaceID field's value.
func (s *FilterForListNotebookServersInput) SetWorkspaceID(v string) *FilterForListNotebookServersInput {
	s.WorkspaceID = &v
	return s
}

type ItemForListNotebookServersOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Duration *int32 `type:"int32" json:",omitempty"`

	LastActivityTime *int32 `type:"int32" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	OwnerName *string `type:"string" json:",omitempty"`

	StartTime *int32 `type:"int32" json:",omitempty"`

	Status *string `type:"string" json:",omitempty" enum:"EnumOfStatusForListNotebookServersOutput"`

	StorageCapacity *int32 `type:"int32" json:",omitempty"`

	UserID *int32 `type:"int32" json:",omitempty"`

	WorkspaceID *string `type:"string" json:",omitempty"`

	WorkspaceName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ItemForListNotebookServersOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ItemForListNotebookServersOutput) GoString() string {
	return s.String()
}

// SetDuration sets the Duration field's value.
func (s *ItemForListNotebookServersOutput) SetDuration(v int32) *ItemForListNotebookServersOutput {
	s.Duration = &v
	return s
}

// SetLastActivityTime sets the LastActivityTime field's value.
func (s *ItemForListNotebookServersOutput) SetLastActivityTime(v int32) *ItemForListNotebookServersOutput {
	s.LastActivityTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ItemForListNotebookServersOutput) SetName(v string) *ItemForListNotebookServersOutput {
	s.Name = &v
	return s
}

// SetOwnerName sets the OwnerName field's value.
func (s *ItemForListNotebookServersOutput) SetOwnerName(v string) *ItemForListNotebookServersOutput {
	s.OwnerName = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ItemForListNotebookServersOutput) SetStartTime(v int32) *ItemForListNotebookServersOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ItemForListNotebookServersOutput) SetStatus(v string) *ItemForListNotebookServersOutput {
	s.Status = &v
	return s
}

// SetStorageCapacity sets the StorageCapacity field's value.
func (s *ItemForListNotebookServersOutput) SetStorageCapacity(v int32) *ItemForListNotebookServersOutput {
	s.StorageCapacity = &v
	return s
}

// SetUserID sets the UserID field's value.
func (s *ItemForListNotebookServersOutput) SetUserID(v int32) *ItemForListNotebookServersOutput {
	s.UserID = &v
	return s
}

// SetWorkspaceID sets the WorkspaceID field's value.
func (s *ItemForListNotebookServersOutput) SetWorkspaceID(v string) *ItemForListNotebookServersOutput {
	s.WorkspaceID = &v
	return s
}

// SetWorkspaceName sets the WorkspaceName field's value.
func (s *ItemForListNotebookServersOutput) SetWorkspaceName(v string) *ItemForListNotebookServersOutput {
	s.WorkspaceName = &v
	return s
}

type ListNotebookServersInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Filter *FilterForListNotebookServersInput `type:"structure" json:",omitempty"`

	PageNumber *int32 `min:"1" type:"int32" json:",omitempty"`

	PageSize *int32 `max:"100" type:"int32" json:",omitempty"`

	SortBy *string `type:"string" json:",omitempty" enum:"EnumOfSortByForListNotebookServersInput"`

	SortOrder *string `type:"string" json:",omitempty" enum:"EnumOfSortOrderForListNotebookServersInput"`
}

// String returns the string representation
func (s ListNotebookServersInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNotebookServersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNotebookServersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNotebookServersInput"}
	if s.PageNumber != nil && *s.PageNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageNumber", 1))
	}
	if s.PageSize != nil && *s.PageSize > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 100))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListNotebookServersInput) SetFilter(v *FilterForListNotebookServersInput) *ListNotebookServersInput {
	s.Filter = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListNotebookServersInput) SetPageNumber(v int32) *ListNotebookServersInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListNotebookServersInput) SetPageSize(v int32) *ListNotebookServersInput {
	s.PageSize = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListNotebookServersInput) SetSortBy(v string) *ListNotebookServersInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListNotebookServersInput) SetSortOrder(v string) *ListNotebookServersInput {
	s.SortOrder = &v
	return s
}

type ListNotebookServersOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Items []*ItemForListNotebookServersOutput `type:"list" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ListNotebookServersOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNotebookServersOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListNotebookServersOutput) SetItems(v []*ItemForListNotebookServersOutput) *ListNotebookServersOutput {
	s.Items = v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListNotebookServersOutput) SetTotalCount(v int32) *ListNotebookServersOutput {
	s.TotalCount = &v
	return s
}

const (
	// EnumOfSortByForListNotebookServersInputOwnerName is a EnumOfSortByForListNotebookServersInput enum value
	EnumOfSortByForListNotebookServersInputOwnerName = "OwnerName"

	// EnumOfSortByForListNotebookServersInputStartTime is a EnumOfSortByForListNotebookServersInput enum value
	EnumOfSortByForListNotebookServersInputStartTime = "StartTime"

	// EnumOfSortByForListNotebookServersInputStorageCapacity is a EnumOfSortByForListNotebookServersInput enum value
	EnumOfSortByForListNotebookServersInputStorageCapacity = "StorageCapacity"

	// EnumOfSortByForListNotebookServersInputLastActivityTime is a EnumOfSortByForListNotebookServersInput enum value
	EnumOfSortByForListNotebookServersInputLastActivityTime = "LastActivityTime"
)

const (
	// EnumOfSortOrderForListNotebookServersInputAsc is a EnumOfSortOrderForListNotebookServersInput enum value
	EnumOfSortOrderForListNotebookServersInputAsc = "Asc"

	// EnumOfSortOrderForListNotebookServersInputDesc is a EnumOfSortOrderForListNotebookServersInput enum value
	EnumOfSortOrderForListNotebookServersInputDesc = "Desc"
)

const (
	// EnumOfStatusForListNotebookServersOutputSpawn is a EnumOfStatusForListNotebookServersOutput enum value
	EnumOfStatusForListNotebookServersOutputSpawn = "spawn"

	// EnumOfStatusForListNotebookServersOutputReady is a EnumOfStatusForListNotebookServersOutput enum value
	EnumOfStatusForListNotebookServersOutputReady = "ready"

	// EnumOfStatusForListNotebookServersOutputStop is a EnumOfStatusForListNotebookServersOutput enum value
	EnumOfStatusForListNotebookServersOutputStop = "stop"

	// EnumOfStatusForListNotebookServersOutputAbsent is a EnumOfStatusForListNotebookServersOutput enum value
	EnumOfStatusForListNotebookServersOutputAbsent = "absent"
)
