// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package bio

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateDataModelCommon = "CreateDataModel"

// CreateDataModelCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateDataModelCommon operation. The "output" return
// value will be populated with the CreateDataModelCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateDataModelCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateDataModelCommon Send returns without error.
//
// See CreateDataModelCommon for more information on using the CreateDataModelCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateDataModelCommonRequest method.
//    req, resp := client.CreateDataModelCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *BIO) CreateDataModelCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateDataModelCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateDataModelCommon API operation for BIO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for BIO's
// API operation CreateDataModelCommon for usage and error information.
func (c *BIO) CreateDataModelCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateDataModelCommonRequest(input)
	return out, req.Send()
}

// CreateDataModelCommonWithContext is the same as CreateDataModelCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataModelCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BIO) CreateDataModelCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateDataModelCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataModel = "CreateDataModel"

// CreateDataModelRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateDataModel operation. The "output" return
// value will be populated with the CreateDataModelCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateDataModelCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateDataModelCommon Send returns without error.
//
// See CreateDataModel for more information on using the CreateDataModel
// API call, and error handling.
//
//    // Example sending a request using the CreateDataModelRequest method.
//    req, resp := client.CreateDataModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *BIO) CreateDataModelRequest(input *CreateDataModelInput) (req *request.Request, output *CreateDataModelOutput) {
	op := &request.Operation{
		Name:       opCreateDataModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDataModelInput{}
	}

	output = &CreateDataModelOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateDataModel API operation for BIO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for BIO's
// API operation CreateDataModel for usage and error information.
func (c *BIO) CreateDataModel(input *CreateDataModelInput) (*CreateDataModelOutput, error) {
	req, out := c.CreateDataModelRequest(input)
	return out, req.Send()
}

// CreateDataModelWithContext is the same as CreateDataModel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BIO) CreateDataModelWithContext(ctx volcengine.Context, input *CreateDataModelInput, opts ...request.Option) (*CreateDataModelOutput, error) {
	req, out := c.CreateDataModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateDataModelInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Headers []*string `type:"list" json:",omitempty"`

	// Name is a required field
	Name *string `min:"1" max:"30" type:"string" json:",omitempty" required:"true"`

	RepositorySchema *RepositorySchemaForCreateDataModelInput `type:"structure" json:",omitempty"`

	Rows []*RowForCreateDataModelInput `type:"list" json:",omitempty"`

	// WorkspaceID is a required field
	WorkspaceID *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s CreateDataModelInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDataModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDataModelInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Name != nil && len(*s.Name) > 30 {
		invalidParams.Add(request.NewErrParamMaxLen("Name", 30, *s.Name))
	}
	if s.WorkspaceID == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHeaders sets the Headers field's value.
func (s *CreateDataModelInput) SetHeaders(v []*string) *CreateDataModelInput {
	s.Headers = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDataModelInput) SetName(v string) *CreateDataModelInput {
	s.Name = &v
	return s
}

// SetRepositorySchema sets the RepositorySchema field's value.
func (s *CreateDataModelInput) SetRepositorySchema(v *RepositorySchemaForCreateDataModelInput) *CreateDataModelInput {
	s.RepositorySchema = v
	return s
}

// SetRows sets the Rows field's value.
func (s *CreateDataModelInput) SetRows(v []*RowForCreateDataModelInput) *CreateDataModelInput {
	s.Rows = v
	return s
}

// SetWorkspaceID sets the WorkspaceID field's value.
func (s *CreateDataModelInput) SetWorkspaceID(v string) *CreateDataModelInput {
	s.WorkspaceID = &v
	return s
}

type CreateDataModelOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	ID *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateDataModelOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDataModelOutput) GoString() string {
	return s.String()
}

// SetID sets the ID field's value.
func (s *CreateDataModelOutput) SetID(v string) *CreateDataModelOutput {
	s.ID = &v
	return s
}

type RepositorySchemaForCreateDataModelInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AAIPassport *string `type:"string" json:",omitempty"`

	SchemaID *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s RepositorySchemaForCreateDataModelInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RepositorySchemaForCreateDataModelInput) GoString() string {
	return s.String()
}

// SetAAIPassport sets the AAIPassport field's value.
func (s *RepositorySchemaForCreateDataModelInput) SetAAIPassport(v string) *RepositorySchemaForCreateDataModelInput {
	s.AAIPassport = &v
	return s
}

// SetSchemaID sets the SchemaID field's value.
func (s *RepositorySchemaForCreateDataModelInput) SetSchemaID(v string) *RepositorySchemaForCreateDataModelInput {
	s.SchemaID = &v
	return s
}

type RowForCreateDataModelInput struct {
	_ struct{} `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s RowForCreateDataModelInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RowForCreateDataModelInput) GoString() string {
	return s.String()
}
