// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package bio

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateClusterCommon = "CreateCluster"

// CreateClusterCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateClusterCommon operation. The "output" return
// value will be populated with the CreateClusterCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateClusterCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateClusterCommon Send returns without error.
//
// See CreateClusterCommon for more information on using the CreateClusterCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateClusterCommonRequest method.
//    req, resp := client.CreateClusterCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *BIO) CreateClusterCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateClusterCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateClusterCommon API operation for BIO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for BIO's
// API operation CreateClusterCommon for usage and error information.
func (c *BIO) CreateClusterCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateClusterCommonRequest(input)
	return out, req.Send()
}

// CreateClusterCommonWithContext is the same as CreateClusterCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateClusterCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BIO) CreateClusterCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateClusterCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCluster = "CreateCluster"

// CreateClusterRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateCluster operation. The "output" return
// value will be populated with the CreateClusterCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateClusterCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateClusterCommon Send returns without error.
//
// See CreateCluster for more information on using the CreateCluster
// API call, and error handling.
//
//    // Example sending a request using the CreateClusterRequest method.
//    req, resp := client.CreateClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *BIO) CreateClusterRequest(input *CreateClusterInput) (req *request.Request, output *CreateClusterOutput) {
	op := &request.Operation{
		Name:       opCreateCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateClusterInput{}
	}

	output = &CreateClusterOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateCluster API operation for BIO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for BIO's
// API operation CreateCluster for usage and error information.
func (c *BIO) CreateCluster(input *CreateClusterInput) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	return out, req.Send()
}

// CreateClusterWithContext is the same as CreateCluster with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BIO) CreateClusterWithContext(ctx volcengine.Context, input *CreateClusterInput, opts ...request.Option) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateClusterInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Description *string `max:"300" type:"string" json:",omitempty"`

	// Name is a required field
	Name *string `min:"2" max:"64" type:"string" json:",omitempty" required:"true"`

	SharedConfig *SharedConfigForCreateClusterInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CreateClusterInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateClusterInput"}
	if s.Description != nil && len(*s.Description) > 300 {
		invalidParams.Add(request.NewErrParamMaxLen("Description", 300, *s.Description))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 2))
	}
	if s.Name != nil && len(*s.Name) > 64 {
		invalidParams.Add(request.NewErrParamMaxLen("Name", 64, *s.Name))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateClusterInput) SetDescription(v string) *CreateClusterInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateClusterInput) SetName(v string) *CreateClusterInput {
	s.Name = &v
	return s
}

// SetSharedConfig sets the SharedConfig field's value.
func (s *CreateClusterInput) SetSharedConfig(v *SharedConfigForCreateClusterInput) *CreateClusterInput {
	s.SharedConfig = v
	return s
}

type CreateClusterOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	ID *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateClusterOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterOutput) GoString() string {
	return s.String()
}

// SetID sets the ID field's value.
func (s *CreateClusterOutput) SetID(v string) *CreateClusterOutput {
	s.ID = &v
	return s
}

type SharedConfigForCreateClusterInput struct {
	_ struct{} `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s SharedConfigForCreateClusterInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SharedConfigForCreateClusterInput) GoString() string {
	return s.String()
}
