// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package alb

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateCustomizedCfgCommon = "CreateCustomizedCfg"

// CreateCustomizedCfgCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateCustomizedCfgCommon operation. The "output" return
// value will be populated with the CreateCustomizedCfgCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateCustomizedCfgCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateCustomizedCfgCommon Send returns without error.
//
// See CreateCustomizedCfgCommon for more information on using the CreateCustomizedCfgCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateCustomizedCfgCommonRequest method.
//    req, resp := client.CreateCustomizedCfgCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ALB) CreateCustomizedCfgCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateCustomizedCfgCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// CreateCustomizedCfgCommon API operation for ALB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ALB's
// API operation CreateCustomizedCfgCommon for usage and error information.
func (c *ALB) CreateCustomizedCfgCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateCustomizedCfgCommonRequest(input)
	return out, req.Send()
}

// CreateCustomizedCfgCommonWithContext is the same as CreateCustomizedCfgCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCustomizedCfgCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ALB) CreateCustomizedCfgCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateCustomizedCfgCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCustomizedCfg = "CreateCustomizedCfg"

// CreateCustomizedCfgRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateCustomizedCfg operation. The "output" return
// value will be populated with the CreateCustomizedCfgCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateCustomizedCfgCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateCustomizedCfgCommon Send returns without error.
//
// See CreateCustomizedCfg for more information on using the CreateCustomizedCfg
// API call, and error handling.
//
//    // Example sending a request using the CreateCustomizedCfgRequest method.
//    req, resp := client.CreateCustomizedCfgRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ALB) CreateCustomizedCfgRequest(input *CreateCustomizedCfgInput) (req *request.Request, output *CreateCustomizedCfgOutput) {
	op := &request.Operation{
		Name:       opCreateCustomizedCfg,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCustomizedCfgInput{}
	}

	output = &CreateCustomizedCfgOutput{}
	req = c.newRequest(op, input, output)

	return
}

// CreateCustomizedCfg API operation for ALB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ALB's
// API operation CreateCustomizedCfg for usage and error information.
func (c *ALB) CreateCustomizedCfg(input *CreateCustomizedCfgInput) (*CreateCustomizedCfgOutput, error) {
	req, out := c.CreateCustomizedCfgRequest(input)
	return out, req.Send()
}

// CreateCustomizedCfgWithContext is the same as CreateCustomizedCfg with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCustomizedCfg for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ALB) CreateCustomizedCfgWithContext(ctx volcengine.Context, input *CreateCustomizedCfgInput, opts ...request.Option) (*CreateCustomizedCfgOutput, error) {
	req, out := c.CreateCustomizedCfgRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateCustomizedCfgInput struct {
	_ struct{} `type:"structure"`

	// CustomizedCfgContent is a required field
	CustomizedCfgContent *string `min:"1" max:"4096" type:"string" required:"true"`

	// CustomizedCfgName is a required field
	CustomizedCfgName *string `min:"1" max:"128" type:"string" required:"true"`

	Description *string `min:"1" max:"255" type:"string"`

	ProjectName *string `type:"string"`

	Tags []*TagForCreateCustomizedCfgInput `type:"list"`
}

// String returns the string representation
func (s CreateCustomizedCfgInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCustomizedCfgInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCustomizedCfgInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCustomizedCfgInput"}
	if s.CustomizedCfgContent == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomizedCfgContent"))
	}
	if s.CustomizedCfgContent != nil && len(*s.CustomizedCfgContent) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomizedCfgContent", 1))
	}
	if s.CustomizedCfgContent != nil && len(*s.CustomizedCfgContent) > 4096 {
		invalidParams.Add(request.NewErrParamMaxLen("CustomizedCfgContent", 4096, *s.CustomizedCfgContent))
	}
	if s.CustomizedCfgName == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomizedCfgName"))
	}
	if s.CustomizedCfgName != nil && len(*s.CustomizedCfgName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomizedCfgName", 1))
	}
	if s.CustomizedCfgName != nil && len(*s.CustomizedCfgName) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("CustomizedCfgName", 128, *s.CustomizedCfgName))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Description != nil && len(*s.Description) > 255 {
		invalidParams.Add(request.NewErrParamMaxLen("Description", 255, *s.Description))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomizedCfgContent sets the CustomizedCfgContent field's value.
func (s *CreateCustomizedCfgInput) SetCustomizedCfgContent(v string) *CreateCustomizedCfgInput {
	s.CustomizedCfgContent = &v
	return s
}

// SetCustomizedCfgName sets the CustomizedCfgName field's value.
func (s *CreateCustomizedCfgInput) SetCustomizedCfgName(v string) *CreateCustomizedCfgInput {
	s.CustomizedCfgName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateCustomizedCfgInput) SetDescription(v string) *CreateCustomizedCfgInput {
	s.Description = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateCustomizedCfgInput) SetProjectName(v string) *CreateCustomizedCfgInput {
	s.ProjectName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCustomizedCfgInput) SetTags(v []*TagForCreateCustomizedCfgInput) *CreateCustomizedCfgInput {
	s.Tags = v
	return s
}

type CreateCustomizedCfgOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	CustomizedCfgId *string `type:"string"`

	RequestId *string `type:"string"`
}

// String returns the string representation
func (s CreateCustomizedCfgOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCustomizedCfgOutput) GoString() string {
	return s.String()
}

// SetCustomizedCfgId sets the CustomizedCfgId field's value.
func (s *CreateCustomizedCfgOutput) SetCustomizedCfgId(v string) *CreateCustomizedCfgOutput {
	s.CustomizedCfgId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateCustomizedCfgOutput) SetRequestId(v string) *CreateCustomizedCfgOutput {
	s.RequestId = &v
	return s
}

type TagForCreateCustomizedCfgInput struct {
	_ struct{} `type:"structure"`

	Key *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s TagForCreateCustomizedCfgInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForCreateCustomizedCfgInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForCreateCustomizedCfgInput) SetKey(v string) *TagForCreateCustomizedCfgInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForCreateCustomizedCfgInput) SetValue(v string) *TagForCreateCustomizedCfgInput {
	s.Value = &v
	return s
}
