// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package aiotvideo

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opGetStreamCommon = "GetStream"

// GetStreamCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the GetStreamCommon operation. The "output" return
// value will be populated with the GetStreamCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetStreamCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetStreamCommon Send returns without error.
//
// See GetStreamCommon for more information on using the GetStreamCommon
// API call, and error handling.
//
//    // Example sending a request using the GetStreamCommonRequest method.
//    req, resp := client.GetStreamCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *AIOTVIDEO) GetStreamCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opGetStreamCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// GetStreamCommon API operation for AIOTVIDEO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for AIOTVIDEO's
// API operation GetStreamCommon for usage and error information.
func (c *AIOTVIDEO) GetStreamCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.GetStreamCommonRequest(input)
	return out, req.Send()
}

// GetStreamCommonWithContext is the same as GetStreamCommon with the addition of
// the ability to pass a context and additional request options.
//
// See GetStreamCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AIOTVIDEO) GetStreamCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.GetStreamCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStream = "GetStream"

// GetStreamRequest generates a "volcengine/request.Request" representing the
// client's request for the GetStream operation. The "output" return
// value will be populated with the GetStreamCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetStreamCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetStreamCommon Send returns without error.
//
// See GetStream for more information on using the GetStream
// API call, and error handling.
//
//    // Example sending a request using the GetStreamRequest method.
//    req, resp := client.GetStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *AIOTVIDEO) GetStreamRequest(input *GetStreamInput) (req *request.Request, output *GetStreamOutput) {
	op := &request.Operation{
		Name:       opGetStream,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetStreamInput{}
	}

	output = &GetStreamOutput{}
	req = c.newRequest(op, input, output)

	return
}

// GetStream API operation for AIOTVIDEO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for AIOTVIDEO's
// API operation GetStream for usage and error information.
func (c *AIOTVIDEO) GetStream(input *GetStreamInput) (*GetStreamOutput, error) {
	req, out := c.GetStreamRequest(input)
	return out, req.Send()
}

// GetStreamWithContext is the same as GetStream with the addition of
// the ability to pass a context and additional request options.
//
// See GetStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AIOTVIDEO) GetStreamWithContext(ctx volcengine.Context, input *GetStreamInput, opts ...request.Option) (*GetStreamOutput, error) {
	req, out := c.GetStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AIForGetStreamOutput struct {
	_ struct{} `type:"structure"`

	TemplateID *string `type:"string"`

	TemplateName *string `type:"string"`
}

// String returns the string representation
func (s AIForGetStreamOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AIForGetStreamOutput) GoString() string {
	return s.String()
}

// SetTemplateID sets the TemplateID field's value.
func (s *AIForGetStreamOutput) SetTemplateID(v string) *AIForGetStreamOutput {
	s.TemplateID = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *AIForGetStreamOutput) SetTemplateName(v string) *AIForGetStreamOutput {
	s.TemplateName = &v
	return s
}

type GetStreamInput struct {
	_ struct{} `type:"structure"`

	FreshExpiredPull *string `type:"string"`

	FreshExpiredPush *string `type:"string"`

	SpaceID *string `type:"string"`

	StreamID *string `type:"string"`

	StreamName *string `type:"string"`

	// StreamingIndex is a required field
	StreamingIndex *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetStreamInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStreamInput"}
	if s.StreamingIndex == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamingIndex"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFreshExpiredPull sets the FreshExpiredPull field's value.
func (s *GetStreamInput) SetFreshExpiredPull(v string) *GetStreamInput {
	s.FreshExpiredPull = &v
	return s
}

// SetFreshExpiredPush sets the FreshExpiredPush field's value.
func (s *GetStreamInput) SetFreshExpiredPush(v string) *GetStreamInput {
	s.FreshExpiredPush = &v
	return s
}

// SetSpaceID sets the SpaceID field's value.
func (s *GetStreamInput) SetSpaceID(v string) *GetStreamInput {
	s.SpaceID = &v
	return s
}

// SetStreamID sets the StreamID field's value.
func (s *GetStreamInput) SetStreamID(v string) *GetStreamInput {
	s.StreamID = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *GetStreamInput) SetStreamName(v string) *GetStreamInput {
	s.StreamName = &v
	return s
}

// SetStreamingIndex sets the StreamingIndex field's value.
func (s *GetStreamInput) SetStreamingIndex(v string) *GetStreamInput {
	s.StreamingIndex = &v
	return s
}

type GetStreamOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	AI *AIForGetStreamOutput `type:"structure"`

	ChannelID *string `type:"string"`

	CreatedAt *string `type:"string"`

	Description *string `type:"string"`

	DeviceID *string `type:"string"`

	DeviceNSID *string `type:"string"`

	PullSource *string `type:"string"`

	PullUrls []*string `type:"list"`

	PushUrl *string `type:"string"`

	RTMPushUrl *string `type:"string"`

	RecentPushTs *string `type:"string"`

	Record *RecordForGetStreamOutput `type:"structure"`

	Resolution *string `type:"string"`

	RtpTransportTcp *bool `type:"boolean"`

	SIPID *string `type:"string"`

	Screenshot *ScreenshotForGetStreamOutput `type:"structure"`

	SpaceAccessType *string `type:"string"`

	SpaceID *string `type:"string"`

	Status *string `type:"string"`

	StreamID *string `type:"string"`

	StreamName *string `type:"string"`

	StreamingType *string `type:"string"`

	TransPullUrls *TransPullUrlsForGetStreamOutput `type:"structure"`

	UpdatedAt *string `type:"string"`
}

// String returns the string representation
func (s GetStreamOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStreamOutput) GoString() string {
	return s.String()
}

// SetAI sets the AI field's value.
func (s *GetStreamOutput) SetAI(v *AIForGetStreamOutput) *GetStreamOutput {
	s.AI = v
	return s
}

// SetChannelID sets the ChannelID field's value.
func (s *GetStreamOutput) SetChannelID(v string) *GetStreamOutput {
	s.ChannelID = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetStreamOutput) SetCreatedAt(v string) *GetStreamOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetStreamOutput) SetDescription(v string) *GetStreamOutput {
	s.Description = &v
	return s
}

// SetDeviceID sets the DeviceID field's value.
func (s *GetStreamOutput) SetDeviceID(v string) *GetStreamOutput {
	s.DeviceID = &v
	return s
}

// SetDeviceNSID sets the DeviceNSID field's value.
func (s *GetStreamOutput) SetDeviceNSID(v string) *GetStreamOutput {
	s.DeviceNSID = &v
	return s
}

// SetPullSource sets the PullSource field's value.
func (s *GetStreamOutput) SetPullSource(v string) *GetStreamOutput {
	s.PullSource = &v
	return s
}

// SetPullUrls sets the PullUrls field's value.
func (s *GetStreamOutput) SetPullUrls(v []*string) *GetStreamOutput {
	s.PullUrls = v
	return s
}

// SetPushUrl sets the PushUrl field's value.
func (s *GetStreamOutput) SetPushUrl(v string) *GetStreamOutput {
	s.PushUrl = &v
	return s
}

// SetRTMPushUrl sets the RTMPushUrl field's value.
func (s *GetStreamOutput) SetRTMPushUrl(v string) *GetStreamOutput {
	s.RTMPushUrl = &v
	return s
}

// SetRecentPushTs sets the RecentPushTs field's value.
func (s *GetStreamOutput) SetRecentPushTs(v string) *GetStreamOutput {
	s.RecentPushTs = &v
	return s
}

// SetRecord sets the Record field's value.
func (s *GetStreamOutput) SetRecord(v *RecordForGetStreamOutput) *GetStreamOutput {
	s.Record = v
	return s
}

// SetResolution sets the Resolution field's value.
func (s *GetStreamOutput) SetResolution(v string) *GetStreamOutput {
	s.Resolution = &v
	return s
}

// SetRtpTransportTcp sets the RtpTransportTcp field's value.
func (s *GetStreamOutput) SetRtpTransportTcp(v bool) *GetStreamOutput {
	s.RtpTransportTcp = &v
	return s
}

// SetSIPID sets the SIPID field's value.
func (s *GetStreamOutput) SetSIPID(v string) *GetStreamOutput {
	s.SIPID = &v
	return s
}

// SetScreenshot sets the Screenshot field's value.
func (s *GetStreamOutput) SetScreenshot(v *ScreenshotForGetStreamOutput) *GetStreamOutput {
	s.Screenshot = v
	return s
}

// SetSpaceAccessType sets the SpaceAccessType field's value.
func (s *GetStreamOutput) SetSpaceAccessType(v string) *GetStreamOutput {
	s.SpaceAccessType = &v
	return s
}

// SetSpaceID sets the SpaceID field's value.
func (s *GetStreamOutput) SetSpaceID(v string) *GetStreamOutput {
	s.SpaceID = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetStreamOutput) SetStatus(v string) *GetStreamOutput {
	s.Status = &v
	return s
}

// SetStreamID sets the StreamID field's value.
func (s *GetStreamOutput) SetStreamID(v string) *GetStreamOutput {
	s.StreamID = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *GetStreamOutput) SetStreamName(v string) *GetStreamOutput {
	s.StreamName = &v
	return s
}

// SetStreamingType sets the StreamingType field's value.
func (s *GetStreamOutput) SetStreamingType(v string) *GetStreamOutput {
	s.StreamingType = &v
	return s
}

// SetTransPullUrls sets the TransPullUrls field's value.
func (s *GetStreamOutput) SetTransPullUrls(v *TransPullUrlsForGetStreamOutput) *GetStreamOutput {
	s.TransPullUrls = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetStreamOutput) SetUpdatedAt(v string) *GetStreamOutput {
	s.UpdatedAt = &v
	return s
}

type RecordForGetStreamOutput struct {
	_ struct{} `type:"structure"`

	TemplateID *string `type:"string"`

	TemplateName *string `type:"string"`
}

// String returns the string representation
func (s RecordForGetStreamOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RecordForGetStreamOutput) GoString() string {
	return s.String()
}

// SetTemplateID sets the TemplateID field's value.
func (s *RecordForGetStreamOutput) SetTemplateID(v string) *RecordForGetStreamOutput {
	s.TemplateID = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *RecordForGetStreamOutput) SetTemplateName(v string) *RecordForGetStreamOutput {
	s.TemplateName = &v
	return s
}

type ScreenshotForGetStreamOutput struct {
	_ struct{} `type:"structure"`

	TemplateID *string `type:"string"`

	TemplateName *string `type:"string"`
}

// String returns the string representation
func (s ScreenshotForGetStreamOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ScreenshotForGetStreamOutput) GoString() string {
	return s.String()
}

// SetTemplateID sets the TemplateID field's value.
func (s *ScreenshotForGetStreamOutput) SetTemplateID(v string) *ScreenshotForGetStreamOutput {
	s.TemplateID = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *ScreenshotForGetStreamOutput) SetTemplateName(v string) *ScreenshotForGetStreamOutput {
	s.TemplateName = &v
	return s
}

type TransPullUrlsForGetStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TransPullUrlsForGetStreamOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TransPullUrlsForGetStreamOutput) GoString() string {
	return s.String()
}
