// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package aiotvideo

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateStreamCommon = "CreateStream"

// CreateStreamCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateStreamCommon operation. The "output" return
// value will be populated with the CreateStreamCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateStreamCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateStreamCommon Send returns without error.
//
// See CreateStreamCommon for more information on using the CreateStreamCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateStreamCommonRequest method.
//    req, resp := client.CreateStreamCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *AIOTVIDEO) CreateStreamCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateStreamCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateStreamCommon API operation for AIOTVIDEO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for AIOTVIDEO's
// API operation CreateStreamCommon for usage and error information.
func (c *AIOTVIDEO) CreateStreamCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateStreamCommonRequest(input)
	return out, req.Send()
}

// CreateStreamCommonWithContext is the same as CreateStreamCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStreamCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AIOTVIDEO) CreateStreamCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateStreamCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStream = "CreateStream"

// CreateStreamRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateStream operation. The "output" return
// value will be populated with the CreateStreamCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateStreamCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateStreamCommon Send returns without error.
//
// See CreateStream for more information on using the CreateStream
// API call, and error handling.
//
//    // Example sending a request using the CreateStreamRequest method.
//    req, resp := client.CreateStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *AIOTVIDEO) CreateStreamRequest(input *CreateStreamInput) (req *request.Request, output *CreateStreamOutput) {
	op := &request.Operation{
		Name:       opCreateStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStreamInput{}
	}

	output = &CreateStreamOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateStream API operation for AIOTVIDEO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for AIOTVIDEO's
// API operation CreateStream for usage and error information.
func (c *AIOTVIDEO) CreateStream(input *CreateStreamInput) (*CreateStreamOutput, error) {
	req, out := c.CreateStreamRequest(input)
	return out, req.Send()
}

// CreateStreamWithContext is the same as CreateStream with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AIOTVIDEO) CreateStreamWithContext(ctx volcengine.Context, input *CreateStreamInput, opts ...request.Option) (*CreateStreamOutput, error) {
	req, out := c.CreateStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateStreamInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	Destination *string `type:"string" json:",omitempty"`

	PullSource *string `type:"string" json:",omitempty"`

	// SpaceID is a required field
	SpaceID *string `type:"string" json:",omitempty" required:"true"`

	// StreamName is a required field
	StreamName *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s CreateStreamInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStreamInput"}
	if s.SpaceID == nil {
		invalidParams.Add(request.NewErrParamRequired("SpaceID"))
	}
	if s.StreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateStreamInput) SetDescription(v string) *CreateStreamInput {
	s.Description = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *CreateStreamInput) SetDestination(v string) *CreateStreamInput {
	s.Destination = &v
	return s
}

// SetPullSource sets the PullSource field's value.
func (s *CreateStreamInput) SetPullSource(v string) *CreateStreamInput {
	s.PullSource = &v
	return s
}

// SetSpaceID sets the SpaceID field's value.
func (s *CreateStreamInput) SetSpaceID(v string) *CreateStreamInput {
	s.SpaceID = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *CreateStreamInput) SetStreamName(v string) *CreateStreamInput {
	s.StreamName = &v
	return s
}

type CreateStreamOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	ID *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateStreamOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStreamOutput) GoString() string {
	return s.String()
}

// SetID sets the ID field's value.
func (s *CreateStreamOutput) SetID(v string) *CreateStreamOutput {
	s.ID = &v
	return s
}
