// Example Code generated by Beijing Volcanoengine Technology.
package directconnectexample

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/service/directconnect"
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/credentials"
	"github.com/volcengine/volcengine-go-sdk/volcengine/session"
)

func CreateDirectConnectVirtualInterface() {
	ak, sk, region := "Your AK", "Your SK", "cn-beijing"
	config := volcengine.NewConfig().
		WithRegion(region).
		WithCredentials(credentials.NewStaticCredentials(ak, sk, ""))
	sess, err := session.NewSession(config)
	if err != nil {
		panic(err)
	}
	svc := directconnect.New(sess)
	createDirectConnectVirtualInterfaceInput := &directconnect.CreateDirectConnectVirtualInterfaceInput{
		Description:               volcengine.String("test"),
		DirectConnectConnectionId: volcengine.String("dcc-2fe3zsmkshs59g****"),
		DirectConnectGatewayId:    volcengine.String("dcg-7qthudw0ll6jmc****"),
		LocalIp:                   volcengine.String("192.XX.XX.10/24"),
		PeerIp:                    volcengine.String("192.XX.XX.20/24"),
		VirtualInterfaceName:      volcengine.String("test"),
		VlanId:                    volcengine.Int64(2000),
	}

	resp, err := svc.CreateDirectConnectVirtualInterface(createDirectConnectVirtualInterfaceInput)
	if err != nil {
		panic(err)
	}
	fmt.Println(resp)
}
