// Example Code generated by Beijing Volcanoengine Technology.
package directconnectexample

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/service/directconnect"
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/credentials"
	"github.com/volcengine/volcengine-go-sdk/volcengine/session"
)

func CreateDirectConnectConnectionOrder() {
	ak, sk, region := "Your AK", "Your SK", "cn-beijing"
	config := volcengine.NewConfig().
		WithRegion(region).
		WithCredentials(credentials.NewStaticCredentials(ak, sk, ""))
	sess, err := session.NewSession(config)
	if err != nil {
		panic(err)
	}
	svc := directconnect.New(sess)
	createDirectConnectConnectionOrderInput := &directconnect.CreateDirectConnectConnectionOrderInput{
		DirectConnectConnectionId: volcengine.String("dcc-8njk2nl32bd232b****"),
		Period:                    volcengine.Int64(1),
		PeriodUnit:                volcengine.String("Month"),
	}

	resp, err := svc.CreateDirectConnectConnectionOrder(createDirectConnectConnectionOrderInput)
	if err != nil {
		panic(err)
	}
	fmt.Println(resp)
}
