// Example Code generated by Beijing Volcanoengine Technology.
package autoscalingexample

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/service/autoscaling"
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/credentials"
	"github.com/volcengine/volcengine-go-sdk/volcengine/session"
)

func CreateScalingGroup() {
	ak, sk, region := "Your AK", "Your SK", "cn-beijing"
	config := volcengine.NewConfig().
		WithRegion(region).
		WithCredentials(credentials.NewStaticCredentials(ak, sk, ""))
	sess, err := session.NewSession(config)
	if err != nil {
		panic(err)
	}
	svc := autoscaling.New(sess)
	createScalingGroupInput := &autoscaling.CreateScalingGroupInput{
		MaxInstanceNumber: volcengine.Int32(10),
		MinInstanceNumber: volcengine.Int32(1),
		ScalingGroupName:  volcengine.String("scaling-group-test"),
		SubnetIds:         volcengine.StringSlice([]string{"subnet-inaimn26s8ow8gbssyxi****"}),
	}

	resp, err := svc.CreateScalingGroup(createScalingGroupInput)
	if err != nil {
		panic(err)
	}
	fmt.Println(resp)
}
