package webplus

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAppEnvStatus invokes the webplus.DescribeAppEnvStatus API synchronously
// api document: https://help.aliyun.com/api/webplus/describeappenvstatus.html
func (client *Client) DescribeAppEnvStatus(request *DescribeAppEnvStatusRequest) (response *DescribeAppEnvStatusResponse, err error) {
	response = CreateDescribeAppEnvStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAppEnvStatusWithChan invokes the webplus.DescribeAppEnvStatus API asynchronously
// api document: https://help.aliyun.com/api/webplus/describeappenvstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAppEnvStatusWithChan(request *DescribeAppEnvStatusRequest) (<-chan *DescribeAppEnvStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeAppEnvStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAppEnvStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAppEnvStatusWithCallback invokes the webplus.DescribeAppEnvStatus API asynchronously
// api document: https://help.aliyun.com/api/webplus/describeappenvstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAppEnvStatusWithCallback(request *DescribeAppEnvStatusRequest, callback func(response *DescribeAppEnvStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAppEnvStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeAppEnvStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAppEnvStatusRequest is the request struct for api DescribeAppEnvStatus
type DescribeAppEnvStatusRequest struct {
	*requests.RoaRequest
	EnvId string `position:"Query" name:"EnvId"`
}

// DescribeAppEnvStatusResponse is the response struct for api DescribeAppEnvStatus
type DescribeAppEnvStatusResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Code      string    `json:"Code" xml:"Code"`
	Message   string    `json:"Message" xml:"Message"`
	EnvStatus EnvStatus `json:"EnvStatus" xml:"EnvStatus"`
}

// CreateDescribeAppEnvStatusRequest creates a request to invoke DescribeAppEnvStatus API
func CreateDescribeAppEnvStatusRequest() (request *DescribeAppEnvStatusRequest) {
	request = &DescribeAppEnvStatusRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("WebPlus", "2019-03-20", "DescribeAppEnvStatus", "/pop/v1/wam/appEnv/status", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeAppEnvStatusResponse creates a response to parse from DescribeAppEnvStatus response
func CreateDescribeAppEnvStatusResponse() (response *DescribeAppEnvStatusResponse) {
	response = &DescribeAppEnvStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
