package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateRenderingDevice invokes the vs.CreateRenderingDevice API synchronously
func (client *Client) CreateRenderingDevice(request *CreateRenderingDeviceRequest) (response *CreateRenderingDeviceResponse, err error) {
	response = CreateCreateRenderingDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateRenderingDeviceWithChan invokes the vs.CreateRenderingDevice API asynchronously
func (client *Client) CreateRenderingDeviceWithChan(request *CreateRenderingDeviceRequest) (<-chan *CreateRenderingDeviceResponse, <-chan error) {
	responseChan := make(chan *CreateRenderingDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateRenderingDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateRenderingDeviceWithCallback invokes the vs.CreateRenderingDevice API asynchronously
func (client *Client) CreateRenderingDeviceWithCallback(request *CreateRenderingDeviceRequest, callback func(response *CreateRenderingDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateRenderingDeviceResponse
		var err error
		defer close(result)
		response, err = client.CreateRenderingDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateRenderingDeviceRequest is the request struct for api CreateRenderingDevice
type CreateRenderingDeviceRequest struct {
	*requests.RpcRequest
	ImageId            string           `position:"Query" name:"ImageId"`
	ISP                string           `position:"Query" name:"ISP"`
	SecurityGroupId    string           `position:"Query" name:"SecurityGroupId"`
	Description        string           `position:"Query" name:"Description"`
	Password           string           `position:"Query" name:"Password"`
	InstanceChargeType string           `position:"Query" name:"InstanceChargeType"`
	ShowLog            string           `position:"Query" name:"ShowLog"`
	AutoRenewPeriod    requests.Integer `position:"Query" name:"AutoRenewPeriod"`
	Period             requests.Integer `position:"Query" name:"Period"`
	Count              requests.Integer `position:"Query" name:"Count"`
	Specification      string           `position:"Query" name:"Specification"`
	ClusterId          string           `position:"Query" name:"ClusterId"`
	OwnerId            requests.Integer `position:"Query" name:"OwnerId"`
	PeriodUnit         string           `position:"Query" name:"PeriodUnit"`
	InstanceName       string           `position:"Query" name:"InstanceName"`
	AutoRenew          requests.Boolean `position:"Query" name:"AutoRenew"`
	EdgeNodeName       string           `position:"Query" name:"EdgeNodeName"`
}

// CreateRenderingDeviceResponse is the response struct for api CreateRenderingDevice
type CreateRenderingDeviceResponse struct {
	*responses.BaseResponse
	RequestId   string   `json:"RequestId" xml:"RequestId"`
	InstanceIds []string `json:"InstanceIds" xml:"InstanceIds"`
}

// CreateCreateRenderingDeviceRequest creates a request to invoke CreateRenderingDevice API
func CreateCreateRenderingDeviceRequest() (request *CreateRenderingDeviceRequest) {
	request = &CreateRenderingDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "CreateRenderingDevice", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateRenderingDeviceResponse creates a response to parse from CreateRenderingDevice response
func CreateCreateRenderingDeviceResponse() (response *CreateRenderingDeviceResponse) {
	response = &CreateRenderingDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
