package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyExpressConnectTrafficQosRule invokes the vpc.ModifyExpressConnectTrafficQosRule API synchronously
func (client *Client) ModifyExpressConnectTrafficQosRule(request *ModifyExpressConnectTrafficQosRuleRequest) (response *ModifyExpressConnectTrafficQosRuleResponse, err error) {
	response = CreateModifyExpressConnectTrafficQosRuleResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyExpressConnectTrafficQosRuleWithChan invokes the vpc.ModifyExpressConnectTrafficQosRule API asynchronously
func (client *Client) ModifyExpressConnectTrafficQosRuleWithChan(request *ModifyExpressConnectTrafficQosRuleRequest) (<-chan *ModifyExpressConnectTrafficQosRuleResponse, <-chan error) {
	responseChan := make(chan *ModifyExpressConnectTrafficQosRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyExpressConnectTrafficQosRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyExpressConnectTrafficQosRuleWithCallback invokes the vpc.ModifyExpressConnectTrafficQosRule API asynchronously
func (client *Client) ModifyExpressConnectTrafficQosRuleWithCallback(request *ModifyExpressConnectTrafficQosRuleRequest, callback func(response *ModifyExpressConnectTrafficQosRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyExpressConnectTrafficQosRuleResponse
		var err error
		defer close(result)
		response, err = client.ModifyExpressConnectTrafficQosRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyExpressConnectTrafficQosRuleRequest is the request struct for api ModifyExpressConnectTrafficQosRule
type ModifyExpressConnectTrafficQosRuleRequest struct {
	*requests.RpcRequest
	DstCidr              string           `position:"Query" name:"DstCidr"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	RuleName             string           `position:"Query" name:"RuleName"`
	SrcCidr              string           `position:"Query" name:"SrcCidr"`
	DstIPv6Cidr          string           `position:"Query" name:"DstIPv6Cidr"`
	DstPortRange         string           `position:"Query" name:"DstPortRange"`
	Protocol             string           `position:"Query" name:"Protocol"`
	QosId                string           `position:"Query" name:"QosId"`
	QueueId              string           `position:"Query" name:"QueueId"`
	MatchDscp            requests.Integer `position:"Query" name:"MatchDscp"`
	RuleDescription      string           `position:"Query" name:"RuleDescription"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	RemarkingDscp        requests.Integer `position:"Query" name:"RemarkingDscp"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	Priority             requests.Integer `position:"Query" name:"Priority"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SrcPortRange         string           `position:"Query" name:"SrcPortRange"`
	RuleId               string           `position:"Query" name:"RuleId"`
	SrcIPv6Cidr          string           `position:"Query" name:"SrcIPv6Cidr"`
}

// ModifyExpressConnectTrafficQosRuleResponse is the response struct for api ModifyExpressConnectTrafficQosRule
type ModifyExpressConnectTrafficQosRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyExpressConnectTrafficQosRuleRequest creates a request to invoke ModifyExpressConnectTrafficQosRule API
func CreateModifyExpressConnectTrafficQosRuleRequest() (request *ModifyExpressConnectTrafficQosRuleRequest) {
	request = &ModifyExpressConnectTrafficQosRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ModifyExpressConnectTrafficQosRule", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyExpressConnectTrafficQosRuleResponse creates a response to parse from ModifyExpressConnectTrafficQosRule response
func CreateModifyExpressConnectTrafficQosRuleResponse() (response *ModifyExpressConnectTrafficQosRuleResponse) {
	response = &ModifyExpressConnectTrafficQosRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
