package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitAIImageAuditJob invokes the vod.SubmitAIImageAuditJob API synchronously
func (client *Client) SubmitAIImageAuditJob(request *SubmitAIImageAuditJobRequest) (response *SubmitAIImageAuditJobResponse, err error) {
	response = CreateSubmitAIImageAuditJobResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitAIImageAuditJobWithChan invokes the vod.SubmitAIImageAuditJob API asynchronously
func (client *Client) SubmitAIImageAuditJobWithChan(request *SubmitAIImageAuditJobRequest) (<-chan *SubmitAIImageAuditJobResponse, <-chan error) {
	responseChan := make(chan *SubmitAIImageAuditJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitAIImageAuditJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitAIImageAuditJobWithCallback invokes the vod.SubmitAIImageAuditJob API asynchronously
func (client *Client) SubmitAIImageAuditJobWithCallback(request *SubmitAIImageAuditJobRequest, callback func(response *SubmitAIImageAuditJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitAIImageAuditJobResponse
		var err error
		defer close(result)
		response, err = client.SubmitAIImageAuditJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitAIImageAuditJobRequest is the request struct for api SubmitAIImageAuditJob
type SubmitAIImageAuditJobRequest struct {
	*requests.RpcRequest
	ResourceOwnerId         string `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount    string `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount            string `position:"Query" name:"OwnerAccount"`
	OwnerId                 string `position:"Query" name:"OwnerId"`
	MediaId                 string `position:"Query" name:"MediaId"`
	TemplateId              string `position:"Query" name:"TemplateId"`
	MediaAuditConfiguration string `position:"Query" name:"MediaAuditConfiguration"`
}

// SubmitAIImageAuditJobResponse is the response struct for api SubmitAIImageAuditJob
type SubmitAIImageAuditJobResponse struct {
	*responses.BaseResponse
	JobId     string `json:"JobId" xml:"JobId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSubmitAIImageAuditJobRequest creates a request to invoke SubmitAIImageAuditJob API
func CreateSubmitAIImageAuditJobRequest() (request *SubmitAIImageAuditJobRequest) {
	request = &SubmitAIImageAuditJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "SubmitAIImageAuditJob", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSubmitAIImageAuditJobResponse creates a response to parse from SubmitAIImageAuditJob response
func CreateSubmitAIImageAuditJobResponse() (response *SubmitAIImageAuditJobResponse) {
	response = &SubmitAIImageAuditJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
