package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePlayVideoStatis invokes the vod.DescribePlayVideoStatis API synchronously
func (client *Client) DescribePlayVideoStatis(request *DescribePlayVideoStatisRequest) (response *DescribePlayVideoStatisResponse, err error) {
	response = CreateDescribePlayVideoStatisResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePlayVideoStatisWithChan invokes the vod.DescribePlayVideoStatis API asynchronously
func (client *Client) DescribePlayVideoStatisWithChan(request *DescribePlayVideoStatisRequest) (<-chan *DescribePlayVideoStatisResponse, <-chan error) {
	responseChan := make(chan *DescribePlayVideoStatisResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePlayVideoStatis(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePlayVideoStatisWithCallback invokes the vod.DescribePlayVideoStatis API asynchronously
func (client *Client) DescribePlayVideoStatisWithCallback(request *DescribePlayVideoStatisRequest, callback func(response *DescribePlayVideoStatisResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePlayVideoStatisResponse
		var err error
		defer close(result)
		response, err = client.DescribePlayVideoStatis(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePlayVideoStatisRequest is the request struct for api DescribePlayVideoStatis
type DescribePlayVideoStatisRequest struct {
	*requests.RpcRequest
	StartTime string           `position:"Query" name:"StartTime"`
	EndTime   string           `position:"Query" name:"EndTime"`
	VideoId   string           `position:"Query" name:"VideoId"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribePlayVideoStatisResponse is the response struct for api DescribePlayVideoStatis
type DescribePlayVideoStatisResponse struct {
	*responses.BaseResponse
	RequestId              string                 `json:"RequestId" xml:"RequestId"`
	VideoPlayStatisDetails VideoPlayStatisDetails `json:"VideoPlayStatisDetails" xml:"VideoPlayStatisDetails"`
}

// CreateDescribePlayVideoStatisRequest creates a request to invoke DescribePlayVideoStatis API
func CreateDescribePlayVideoStatisRequest() (request *DescribePlayVideoStatisRequest) {
	request = &DescribePlayVideoStatisRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "DescribePlayVideoStatis", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePlayVideoStatisResponse creates a response to parse from DescribePlayVideoStatis response
func CreateDescribePlayVideoStatisResponse() (response *DescribePlayVideoStatisResponse) {
	response = &DescribePlayVideoStatisResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
