package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMediaDistribution invokes the vod.DescribeMediaDistribution API synchronously
func (client *Client) DescribeMediaDistribution(request *DescribeMediaDistributionRequest) (response *DescribeMediaDistributionResponse, err error) {
	response = CreateDescribeMediaDistributionResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMediaDistributionWithChan invokes the vod.DescribeMediaDistribution API asynchronously
func (client *Client) DescribeMediaDistributionWithChan(request *DescribeMediaDistributionRequest) (<-chan *DescribeMediaDistributionResponse, <-chan error) {
	responseChan := make(chan *DescribeMediaDistributionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMediaDistribution(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMediaDistributionWithCallback invokes the vod.DescribeMediaDistribution API asynchronously
func (client *Client) DescribeMediaDistributionWithCallback(request *DescribeMediaDistributionRequest, callback func(response *DescribeMediaDistributionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMediaDistributionResponse
		var err error
		defer close(result)
		response, err = client.DescribeMediaDistribution(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMediaDistributionRequest is the request struct for api DescribeMediaDistribution
type DescribeMediaDistributionRequest struct {
	*requests.RpcRequest
	EndTime      string `position:"Query" name:"EndTime"`
	StartTime    string `position:"Query" name:"StartTime"`
	StorageClass string `position:"Query" name:"StorageClass"`
	Interval     string `position:"Query" name:"Interval"`
}

// DescribeMediaDistributionResponse is the response struct for api DescribeMediaDistribution
type DescribeMediaDistributionResponse struct {
	*responses.BaseResponse
	RequestId             string              `json:"RequestId" xml:"RequestId"`
	Total                 int64               `json:"Total" xml:"Total"`
	MediaDistributionList []MediaDistribution `json:"MediaDistributionList" xml:"MediaDistributionList"`
}

// CreateDescribeMediaDistributionRequest creates a request to invoke DescribeMediaDistribution API
func CreateDescribeMediaDistributionRequest() (request *DescribeMediaDistributionRequest) {
	request = &DescribeMediaDistributionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "DescribeMediaDistribution", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeMediaDistributionResponse creates a response to parse from DescribeMediaDistribution response
func CreateDescribeMediaDistributionResponse() (response *DescribeMediaDistributionResponse) {
	response = &DescribeMediaDistributionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
