package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateUploadVideo invokes the vod.CreateUploadVideo API synchronously
func (client *Client) CreateUploadVideo(request *CreateUploadVideoRequest) (response *CreateUploadVideoResponse, err error) {
	response = CreateCreateUploadVideoResponse()
	err = client.DoAction(request, response)
	return
}

// CreateUploadVideoWithChan invokes the vod.CreateUploadVideo API asynchronously
func (client *Client) CreateUploadVideoWithChan(request *CreateUploadVideoRequest) (<-chan *CreateUploadVideoResponse, <-chan error) {
	responseChan := make(chan *CreateUploadVideoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateUploadVideo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateUploadVideoWithCallback invokes the vod.CreateUploadVideo API asynchronously
func (client *Client) CreateUploadVideoWithCallback(request *CreateUploadVideoRequest, callback func(response *CreateUploadVideoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateUploadVideoResponse
		var err error
		defer close(result)
		response, err = client.CreateUploadVideo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateUploadVideoRequest is the request struct for api CreateUploadVideo
type CreateUploadVideoRequest struct {
	*requests.RpcRequest
	TranscodeMode   string           `position:"Query" name:"TranscodeMode"`
	Description     string           `position:"Query" name:"Description"`
	FileSize        requests.Integer `position:"Query" name:"FileSize"`
	Title           string           `position:"Query" name:"Title"`
	StorageLocation string           `position:"Query" name:"StorageLocation"`
	CoverURL        string           `position:"Query" name:"CoverURL"`
	UserData        string           `position:"Query" name:"UserData"`
	CateId          requests.Integer `position:"Query" name:"CateId"`
	WorkflowId      string           `position:"Query" name:"WorkflowId"`
	CustomMediaInfo string           `position:"Query" name:"CustomMediaInfo"`
	IP              string           `position:"Query" name:"IP"`
	Tags            string           `position:"Query" name:"Tags"`
	FileName        string           `position:"Query" name:"FileName"`
	TemplateGroupId string           `position:"Query" name:"TemplateGroupId"`
	AppId           string           `position:"Query" name:"AppId"`
}

// CreateUploadVideoResponse is the response struct for api CreateUploadVideo
type CreateUploadVideoResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	UploadAddress string `json:"UploadAddress" xml:"UploadAddress"`
	VideoId       string `json:"VideoId" xml:"VideoId"`
	UploadAuth    string `json:"UploadAuth" xml:"UploadAuth"`
}

// CreateCreateUploadVideoRequest creates a request to invoke CreateUploadVideo API
func CreateCreateUploadVideoRequest() (request *CreateUploadVideoRequest) {
	request = &CreateUploadVideoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "CreateUploadVideo", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateUploadVideoResponse creates a response to parse from CreateUploadVideo response
func CreateCreateUploadVideoResponse() (response *CreateUploadVideoResponse) {
	response = &CreateUploadVideoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
