package viapi_regen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetServiceInvoke invokes the viapi_regen.GetServiceInvoke API synchronously
func (client *Client) GetServiceInvoke(request *GetServiceInvokeRequest) (response *GetServiceInvokeResponse, err error) {
	response = CreateGetServiceInvokeResponse()
	err = client.DoAction(request, response)
	return
}

// GetServiceInvokeWithChan invokes the viapi_regen.GetServiceInvoke API asynchronously
func (client *Client) GetServiceInvokeWithChan(request *GetServiceInvokeRequest) (<-chan *GetServiceInvokeResponse, <-chan error) {
	responseChan := make(chan *GetServiceInvokeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetServiceInvoke(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetServiceInvokeWithCallback invokes the viapi_regen.GetServiceInvoke API asynchronously
func (client *Client) GetServiceInvokeWithCallback(request *GetServiceInvokeRequest, callback func(response *GetServiceInvokeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetServiceInvokeResponse
		var err error
		defer close(result)
		response, err = client.GetServiceInvoke(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetServiceInvokeRequest is the request struct for api GetServiceInvoke
type GetServiceInvokeRequest struct {
	*requests.RpcRequest
	StartTime          requests.Integer `position:"Body" name:"StartTime"`
	Id                 requests.Integer `position:"Body" name:"Id"`
	EndTime            requests.Integer `position:"Body" name:"EndTime"`
	CallerParentIdList *[]string        `position:"Body" name:"CallerParentIdList"  type:"Json"`
}

// GetServiceInvokeResponse is the response struct for api GetServiceInvoke
type GetServiceInvokeResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetServiceInvokeRequest creates a request to invoke GetServiceInvoke API
func CreateGetServiceInvokeRequest() (request *GetServiceInvokeRequest) {
	request = &GetServiceInvokeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("viapi-regen", "2021-11-19", "GetServiceInvoke", "selflearning", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetServiceInvokeResponse creates a response to parse from GetServiceInvoke response
func CreateGetServiceInvokeResponse() (response *GetServiceInvokeResponse) {
	response = &GetServiceInvokeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
