package viapi_regen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDataset invokes the viapi_regen.GetDataset API synchronously
func (client *Client) GetDataset(request *GetDatasetRequest) (response *GetDatasetResponse, err error) {
	response = CreateGetDatasetResponse()
	err = client.DoAction(request, response)
	return
}

// GetDatasetWithChan invokes the viapi_regen.GetDataset API asynchronously
func (client *Client) GetDatasetWithChan(request *GetDatasetRequest) (<-chan *GetDatasetResponse, <-chan error) {
	responseChan := make(chan *GetDatasetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDataset(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDatasetWithCallback invokes the viapi_regen.GetDataset API asynchronously
func (client *Client) GetDatasetWithCallback(request *GetDatasetRequest, callback func(response *GetDatasetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDatasetResponse
		var err error
		defer close(result)
		response, err = client.GetDataset(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDatasetRequest is the request struct for api GetDataset
type GetDatasetRequest struct {
	*requests.RpcRequest
	Id requests.Integer `position:"Body" name:"Id"`
}

// GetDatasetResponse is the response struct for api GetDataset
type GetDatasetResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetDatasetRequest creates a request to invoke GetDataset API
func CreateGetDatasetRequest() (request *GetDatasetRequest) {
	request = &GetDatasetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("viapi-regen", "2021-11-19", "GetDataset", "selflearning", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetDatasetResponse creates a response to parse from GetDataset response
func CreateGetDatasetResponse() (response *GetDatasetResponse) {
	response = &GetDatasetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
