package viapi_regen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DownloadLabelFile invokes the viapi_regen.DownloadLabelFile API synchronously
func (client *Client) DownloadLabelFile(request *DownloadLabelFileRequest) (response *DownloadLabelFileResponse, err error) {
	response = CreateDownloadLabelFileResponse()
	err = client.DoAction(request, response)
	return
}

// DownloadLabelFileWithChan invokes the viapi_regen.DownloadLabelFile API asynchronously
func (client *Client) DownloadLabelFileWithChan(request *DownloadLabelFileRequest) (<-chan *DownloadLabelFileResponse, <-chan error) {
	responseChan := make(chan *DownloadLabelFileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DownloadLabelFile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DownloadLabelFileWithCallback invokes the viapi_regen.DownloadLabelFile API asynchronously
func (client *Client) DownloadLabelFileWithCallback(request *DownloadLabelFileRequest, callback func(response *DownloadLabelFileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DownloadLabelFileResponse
		var err error
		defer close(result)
		response, err = client.DownloadLabelFile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DownloadLabelFileRequest is the request struct for api DownloadLabelFile
type DownloadLabelFileRequest struct {
	*requests.RpcRequest
	LabelId requests.Integer `position:"Body" name:"LabelId"`
}

// DownloadLabelFileResponse is the response struct for api DownloadLabelFile
type DownloadLabelFileResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDownloadLabelFileRequest creates a request to invoke DownloadLabelFile API
func CreateDownloadLabelFileRequest() (request *DownloadLabelFileRequest) {
	request = &DownloadLabelFileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("viapi-regen", "2021-11-19", "DownloadLabelFile", "selflearning", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDownloadLabelFileResponse creates a response to parse from DownloadLabelFile response
func CreateDownloadLabelFileResponse() (response *DownloadLabelFileResponse) {
	response = &DownloadLabelFileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
