package ververica

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFunctions invokes the ververica.ListFunctions API synchronously
func (client *Client) ListFunctions(request *ListFunctionsRequest) (response *ListFunctionsResponse, err error) {
	response = CreateListFunctionsResponse()
	err = client.DoAction(request, response)
	return
}

// ListFunctionsWithChan invokes the ververica.ListFunctions API asynchronously
func (client *Client) ListFunctionsWithChan(request *ListFunctionsRequest) (<-chan *ListFunctionsResponse, <-chan error) {
	responseChan := make(chan *ListFunctionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFunctions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFunctionsWithCallback invokes the ververica.ListFunctions API asynchronously
func (client *Client) ListFunctionsWithCallback(request *ListFunctionsRequest, callback func(response *ListFunctionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFunctionsResponse
		var err error
		defer close(result)
		response, err = client.ListFunctions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFunctionsRequest is the request struct for api ListFunctions
type ListFunctionsRequest struct {
	*requests.RoaRequest
	Workspace string `position:"Path" name:"workspace"`
	Database  string `position:"Query" name:"database"`
	Cat       string `position:"Path" name:"cat"`
	Namespace string `position:"Path" name:"namespace"`
}

// ListFunctionsResponse is the response struct for api ListFunctions
type ListFunctionsResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"success" xml:"success"`
	Data      string `json:"data" xml:"data"`
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateListFunctionsRequest creates a request to invoke ListFunctions API
func CreateListFunctionsRequest() (request *ListFunctionsRequest) {
	request = &ListFunctionsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ververica", "2020-05-01", "ListFunctions", "/pop/workspaces/[workspace]/catalog/v1beta2/namespaces/[namespace]/catalogs/[cat]:listFunctions", "", "")
	request.Method = requests.GET
	return
}

// CreateListFunctionsResponse creates a response to parse from ListFunctions response
func CreateListFunctionsResponse() (response *ListFunctionsResponse) {
	response = &ListFunctionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
