package ververica

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateConnector invokes the ververica.CreateConnector API synchronously
func (client *Client) CreateConnector(request *CreateConnectorRequest) (response *CreateConnectorResponse, err error) {
	response = CreateCreateConnectorResponse()
	err = client.DoAction(request, response)
	return
}

// CreateConnectorWithChan invokes the ververica.CreateConnector API asynchronously
func (client *Client) CreateConnectorWithChan(request *CreateConnectorRequest) (<-chan *CreateConnectorResponse, <-chan error) {
	responseChan := make(chan *CreateConnectorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateConnector(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateConnectorWithCallback invokes the ververica.CreateConnector API asynchronously
func (client *Client) CreateConnectorWithCallback(request *CreateConnectorRequest, callback func(response *CreateConnectorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateConnectorResponse
		var err error
		defer close(result)
		response, err = client.CreateConnector(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateConnectorRequest is the request struct for api CreateConnector
type CreateConnectorRequest struct {
	*requests.RoaRequest
	Workspace  string `position:"Path" name:"workspace"`
	ParamsJson string `position:"Body" name:"paramsJson"`
	Namespace  string `position:"Path" name:"namespace"`
}

// CreateConnectorResponse is the response struct for api CreateConnector
type CreateConnectorResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"success" xml:"success"`
	Data      string `json:"data" xml:"data"`
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateCreateConnectorRequest creates a request to invoke CreateConnector API
func CreateCreateConnectorRequest() (request *CreateConnectorRequest) {
	request = &CreateConnectorRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ververica", "2020-05-01", "CreateConnector", "/pop/workspaces/[workspace]/sql/v1beta1/namespaces/[namespace]/connectors", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateConnectorResponse creates a response to parse from CreateConnector response
func CreateCreateConnectorResponse() (response *CreateConnectorResponse) {
	response = &CreateConnectorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
