package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PushExtraTradeDetail invokes the unimkt.PushExtraTradeDetail API synchronously
func (client *Client) PushExtraTradeDetail(request *PushExtraTradeDetailRequest) (response *PushExtraTradeDetailResponse, err error) {
	response = CreatePushExtraTradeDetailResponse()
	err = client.DoAction(request, response)
	return
}

// PushExtraTradeDetailWithChan invokes the unimkt.PushExtraTradeDetail API asynchronously
func (client *Client) PushExtraTradeDetailWithChan(request *PushExtraTradeDetailRequest) (<-chan *PushExtraTradeDetailResponse, <-chan error) {
	responseChan := make(chan *PushExtraTradeDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PushExtraTradeDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PushExtraTradeDetailWithCallback invokes the unimkt.PushExtraTradeDetail API asynchronously
func (client *Client) PushExtraTradeDetailWithCallback(request *PushExtraTradeDetailRequest, callback func(response *PushExtraTradeDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PushExtraTradeDetailResponse
		var err error
		defer close(result)
		response, err = client.PushExtraTradeDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PushExtraTradeDetailRequest is the request struct for api PushExtraTradeDetail
type PushExtraTradeDetailRequest struct {
	*requests.RpcRequest
	OrderId       string           `position:"Body" name:"OrderId"`
	SalePrice     requests.Float   `position:"Body" name:"SalePrice"`
	TradeStatus   requests.Integer `position:"Body" name:"TradeStatus"`
	CommodityId   string           `position:"Body" name:"CommodityId"`
	DeviceSn      string           `position:"Body" name:"DeviceSn"`
	ChannelId     string           `position:"Body" name:"ChannelId"`
	CommodityName string           `position:"Body" name:"CommodityName"`
	TradeTime     requests.Integer `position:"Body" name:"TradeTime"`
	TradePrice    requests.Float   `position:"Body" name:"TradePrice"`
}

// PushExtraTradeDetailResponse is the response struct for api PushExtraTradeDetail
type PushExtraTradeDetailResponse struct {
	*responses.BaseResponse
	Status    bool   `json:"Status" xml:"Status"`
	Msg       string `json:"Msg" xml:"Msg"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreatePushExtraTradeDetailRequest creates a request to invoke PushExtraTradeDetail API
func CreatePushExtraTradeDetailRequest() (request *PushExtraTradeDetailRequest) {
	request = &PushExtraTradeDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "PushExtraTradeDetail", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePushExtraTradeDetailResponse creates a response to parse from PushExtraTradeDetail response
func CreatePushExtraTradeDetailResponse() (response *PushExtraTradeDetailResponse) {
	response = &PushExtraTradeDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
