package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteProxyBrandUser invokes the unimkt.DeleteProxyBrandUser API synchronously
func (client *Client) DeleteProxyBrandUser(request *DeleteProxyBrandUserRequest) (response *DeleteProxyBrandUserResponse, err error) {
	response = CreateDeleteProxyBrandUserResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteProxyBrandUserWithChan invokes the unimkt.DeleteProxyBrandUser API asynchronously
func (client *Client) DeleteProxyBrandUserWithChan(request *DeleteProxyBrandUserRequest) (<-chan *DeleteProxyBrandUserResponse, <-chan error) {
	responseChan := make(chan *DeleteProxyBrandUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteProxyBrandUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteProxyBrandUserWithCallback invokes the unimkt.DeleteProxyBrandUser API asynchronously
func (client *Client) DeleteProxyBrandUserWithCallback(request *DeleteProxyBrandUserRequest, callback func(response *DeleteProxyBrandUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteProxyBrandUserResponse
		var err error
		defer close(result)
		response, err = client.DeleteProxyBrandUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteProxyBrandUserRequest is the request struct for api DeleteProxyBrandUser
type DeleteProxyBrandUserRequest struct {
	*requests.RpcRequest
	BrandUserNick string           `position:"Query" name:"BrandUserNick"`
	ProxyUserId   requests.Integer `position:"Query" name:"ProxyUserId"`
	ChannelId     string           `position:"Query" name:"ChannelId"`
}

// DeleteProxyBrandUserResponse is the response struct for api DeleteProxyBrandUser
type DeleteProxyBrandUserResponse struct {
	*responses.BaseResponse
	Code      int                      `json:"Code" xml:"Code"`
	Success   bool                     `json:"Success" xml:"Success"`
	ErrorMsg  string                   `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId string                   `json:"RequestId" xml:"RequestId"`
	Data      []map[string]interface{} `json:"Data" xml:"Data"`
}

// CreateDeleteProxyBrandUserRequest creates a request to invoke DeleteProxyBrandUser API
func CreateDeleteProxyBrandUserRequest() (request *DeleteProxyBrandUserRequest) {
	request = &DeleteProxyBrandUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "DeleteProxyBrandUser", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteProxyBrandUserResponse creates a response to parse from DeleteProxyBrandUser response
func CreateDeleteProxyBrandUserResponse() (response *DeleteProxyBrandUserResponse) {
	response = &DeleteProxyBrandUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
