package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreatesSlotTemplate invokes the unimkt.CreatesSlotTemplate API synchronously
func (client *Client) CreatesSlotTemplate(request *CreatesSlotTemplateRequest) (response *CreatesSlotTemplateResponse, err error) {
	response = CreateCreatesSlotTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// CreatesSlotTemplateWithChan invokes the unimkt.CreatesSlotTemplate API asynchronously
func (client *Client) CreatesSlotTemplateWithChan(request *CreatesSlotTemplateRequest) (<-chan *CreatesSlotTemplateResponse, <-chan error) {
	responseChan := make(chan *CreatesSlotTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreatesSlotTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreatesSlotTemplateWithCallback invokes the unimkt.CreatesSlotTemplate API asynchronously
func (client *Client) CreatesSlotTemplateWithCallback(request *CreatesSlotTemplateRequest, callback func(response *CreatesSlotTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreatesSlotTemplateResponse
		var err error
		defer close(result)
		response, err = client.CreatesSlotTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreatesSlotTemplateRequest is the request struct for api CreatesSlotTemplate
type CreatesSlotTemplateRequest struct {
	*requests.RpcRequest
	Business         string `position:"Query" name:"Business"`
	ClientToken      string `position:"Query" name:"ClientToken"`
	UserId           string `position:"Query" name:"UserId"`
	OriginSiteUserId string `position:"Query" name:"OriginSiteUserId"`
	AdSlotTemplate   string `position:"Body" name:"AdSlotTemplate"`
	Environment      string `position:"Query" name:"Environment"`
	AppName          string `position:"Query" name:"AppName"`
	TenantId         string `position:"Query" name:"TenantId"`
	UserSite         string `position:"Query" name:"UserSite"`
}

// CreatesSlotTemplateResponse is the response struct for api CreatesSlotTemplate
type CreatesSlotTemplateResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Model     Model  `json:"Model" xml:"Model"`
}

// CreateCreatesSlotTemplateRequest creates a request to invoke CreatesSlotTemplate API
func CreateCreatesSlotTemplateRequest() (request *CreatesSlotTemplateRequest) {
	request = &CreatesSlotTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "CreatesSlotTemplate", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreatesSlotTemplateResponse creates a response to parse from CreatesSlotTemplate response
func CreateCreatesSlotTemplateResponse() (response *CreatesSlotTemplateResponse) {
	response = &CreatesSlotTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
