package trademark

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InsertTmMonitorRule invokes the trademark.InsertTmMonitorRule API synchronously
// api document: https://help.aliyun.com/api/trademark/inserttmmonitorrule.html
func (client *Client) InsertTmMonitorRule(request *InsertTmMonitorRuleRequest) (response *InsertTmMonitorRuleResponse, err error) {
	response = CreateInsertTmMonitorRuleResponse()
	err = client.DoAction(request, response)
	return
}

// InsertTmMonitorRuleWithChan invokes the trademark.InsertTmMonitorRule API asynchronously
// api document: https://help.aliyun.com/api/trademark/inserttmmonitorrule.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) InsertTmMonitorRuleWithChan(request *InsertTmMonitorRuleRequest) (<-chan *InsertTmMonitorRuleResponse, <-chan error) {
	responseChan := make(chan *InsertTmMonitorRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InsertTmMonitorRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InsertTmMonitorRuleWithCallback invokes the trademark.InsertTmMonitorRule API asynchronously
// api document: https://help.aliyun.com/api/trademark/inserttmmonitorrule.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) InsertTmMonitorRuleWithCallback(request *InsertTmMonitorRuleRequest, callback func(response *InsertTmMonitorRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InsertTmMonitorRuleResponse
		var err error
		defer close(result)
		response, err = client.InsertTmMonitorRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InsertTmMonitorRuleRequest is the request struct for api InsertTmMonitorRule
type InsertTmMonitorRuleRequest struct {
	*requests.RpcRequest
	StartApplyDate string           `position:"Query" name:"StartApplyDate"`
	NotifyStatus   string           `position:"Query" name:"NotifyStatus"`
	RuleType       requests.Integer `position:"Query" name:"RuleType"`
	RuleSource     string           `position:"Query" name:"RuleSource"`
	RuleName       string           `position:"Query" name:"RuleName"`
	EndApplyDate   string           `position:"Query" name:"EndApplyDate"`
	Classification string           `position:"Query" name:"Classification"`
	RuleKeyword    string           `position:"Query" name:"RuleKeyword"`
}

// InsertTmMonitorRuleResponse is the response struct for api InsertTmMonitorRule
type InsertTmMonitorRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateInsertTmMonitorRuleRequest creates a request to invoke InsertTmMonitorRule API
func CreateInsertTmMonitorRuleRequest() (request *InsertTmMonitorRuleRequest) {
	request = &InsertTmMonitorRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Trademark", "2018-07-24", "InsertTmMonitorRule", "trademark", "openAPI")
	return
}

// CreateInsertTmMonitorRuleResponse creates a response to parse from InsertTmMonitorRule response
func CreateInsertTmMonitorRuleResponse() (response *InsertTmMonitorRuleResponse) {
	response = &InsertTmMonitorRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
