package teambition_aliyun

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ApplySmallMicro invokes the teambition_aliyun.ApplySmallMicro API synchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/applysmallmicro.html
func (client *Client) ApplySmallMicro(request *ApplySmallMicroRequest) (response *ApplySmallMicroResponse, err error) {
	response = CreateApplySmallMicroResponse()
	err = client.DoAction(request, response)
	return
}

// ApplySmallMicroWithChan invokes the teambition_aliyun.ApplySmallMicro API asynchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/applysmallmicro.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ApplySmallMicroWithChan(request *ApplySmallMicroRequest) (<-chan *ApplySmallMicroResponse, <-chan error) {
	responseChan := make(chan *ApplySmallMicroResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ApplySmallMicro(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ApplySmallMicroWithCallback invokes the teambition_aliyun.ApplySmallMicro API asynchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/applysmallmicro.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ApplySmallMicroWithCallback(request *ApplySmallMicroRequest, callback func(response *ApplySmallMicroResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ApplySmallMicroResponse
		var err error
		defer close(result)
		response, err = client.ApplySmallMicro(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ApplySmallMicroRequest is the request struct for api ApplySmallMicro
type ApplySmallMicroRequest struct {
	*requests.RpcRequest
	ApplicantEmail    string `position:"Body" name:"ApplicantEmail"`
	DevelopScale      string `position:"Query" name:"DevelopScale"`
	Type              string `position:"Body" name:"Type"`
	OrgId             string `position:"Body" name:"OrgId"`
	ApplicantPosition string `position:"Body" name:"ApplicantPosition"`
	DevelopLanguage   string `position:"Body" name:"DevelopLanguage"`
	OrgName           string `position:"Body" name:"OrgName"`
	ApplicantTel      string `position:"Body" name:"ApplicantTel"`
	Solution          string `position:"Body" name:"Solution"`
	ForHelp           string `position:"Body" name:"ForHelp"`
	ApplicantName     string `position:"Body" name:"ApplicantName"`
	BusinessModel     string `position:"Body" name:"BusinessModel"`
}

// ApplySmallMicroResponse is the response struct for api ApplySmallMicro
type ApplySmallMicroResponse struct {
	*responses.BaseResponse
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	Code      int                    `json:"code" xml:"code"`
	Result    map[string]interface{} `json:"result" xml:"result"`
	Message   bool                   `json:"message" xml:"message"`
	Raw       bool                   `json:"raw" xml:"raw"`
}

// CreateApplySmallMicroRequest creates a request to invoke ApplySmallMicro API
func CreateApplySmallMicroRequest() (request *ApplySmallMicroRequest) {
	request = &ApplySmallMicroRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("teambition-aliyun", "2020-02-26", "ApplySmallMicro", "", "")
	request.Method = requests.POST
	return
}

// CreateApplySmallMicroResponse creates a response to parse from ApplySmallMicro response
func CreateApplySmallMicroResponse() (response *ApplySmallMicroResponse) {
	response = &ApplySmallMicroResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
