package tag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CloseCreatedBy invokes the tag.CloseCreatedBy API synchronously
func (client *Client) CloseCreatedBy(request *CloseCreatedByRequest) (response *CloseCreatedByResponse, err error) {
	response = CreateCloseCreatedByResponse()
	err = client.DoAction(request, response)
	return
}

// CloseCreatedByWithChan invokes the tag.CloseCreatedBy API asynchronously
func (client *Client) CloseCreatedByWithChan(request *CloseCreatedByRequest) (<-chan *CloseCreatedByResponse, <-chan error) {
	responseChan := make(chan *CloseCreatedByResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CloseCreatedBy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CloseCreatedByWithCallback invokes the tag.CloseCreatedBy API asynchronously
func (client *Client) CloseCreatedByWithCallback(request *CloseCreatedByRequest, callback func(response *CloseCreatedByResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CloseCreatedByResponse
		var err error
		defer close(result)
		response, err = client.CloseCreatedBy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CloseCreatedByRequest is the request struct for api CloseCreatedBy
type CloseCreatedByRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      string           `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// CloseCreatedByResponse is the response struct for api CloseCreatedBy
type CloseCreatedByResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCloseCreatedByRequest creates a request to invoke CloseCreatedBy API
func CreateCloseCreatedByRequest() (request *CloseCreatedByRequest) {
	request = &CloseCreatedByRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Tag", "2018-08-28", "CloseCreatedBy", "tag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCloseCreatedByResponse creates a response to parse from CloseCreatedBy response
func CreateCloseCreatedByResponse() (response *CloseCreatedByResponse) {
	response = &CloseCreatedByResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
