package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFirewallRules invokes the swas_open.ListFirewallRules API synchronously
func (client *Client) ListFirewallRules(request *ListFirewallRulesRequest) (response *ListFirewallRulesResponse, err error) {
	response = CreateListFirewallRulesResponse()
	err = client.DoAction(request, response)
	return
}

// ListFirewallRulesWithChan invokes the swas_open.ListFirewallRules API asynchronously
func (client *Client) ListFirewallRulesWithChan(request *ListFirewallRulesRequest) (<-chan *ListFirewallRulesResponse, <-chan error) {
	responseChan := make(chan *ListFirewallRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFirewallRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFirewallRulesWithCallback invokes the swas_open.ListFirewallRules API asynchronously
func (client *Client) ListFirewallRulesWithCallback(request *ListFirewallRulesRequest, callback func(response *ListFirewallRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFirewallRulesResponse
		var err error
		defer close(result)
		response, err = client.ListFirewallRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFirewallRulesRequest is the request struct for api ListFirewallRules
type ListFirewallRulesRequest struct {
	*requests.RpcRequest
	PageNumber     requests.Integer        `position:"Query" name:"PageNumber"`
	InstanceId     string                  `position:"Query" name:"InstanceId"`
	PageSize       requests.Integer        `position:"Query" name:"PageSize"`
	FirewallRuleId string                  `position:"Query" name:"FirewallRuleId"`
	Tag            *[]ListFirewallRulesTag `position:"Query" name:"Tag"  type:"Repeated"`
}

// ListFirewallRulesTag is a repeated param struct in ListFirewallRulesRequest
type ListFirewallRulesTag struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// ListFirewallRulesResponse is the response struct for api ListFirewallRules
type ListFirewallRulesResponse struct {
	*responses.BaseResponse
	TotalCount    int            `json:"TotalCount" xml:"TotalCount"`
	RequestId     string         `json:"RequestId" xml:"RequestId"`
	PageSize      int            `json:"PageSize" xml:"PageSize"`
	PageNumber    int            `json:"PageNumber" xml:"PageNumber"`
	FirewallRules []FirewallRule `json:"FirewallRules" xml:"FirewallRules"`
}

// CreateListFirewallRulesRequest creates a request to invoke ListFirewallRules API
func CreateListFirewallRulesRequest() (request *ListFirewallRulesRequest) {
	request = &ListFirewallRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "ListFirewallRules", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListFirewallRulesResponse creates a response to parse from ListFirewallRules response
func CreateListFirewallRulesResponse() (response *ListFirewallRulesResponse) {
	response = &ListFirewallRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
