package subscription

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSubscriptionItem invokes the subscription.GetSubscriptionItem API synchronously
// api document: https://help.aliyun.com/api/subscription/getsubscriptionitem.html
func (client *Client) GetSubscriptionItem(request *GetSubscriptionItemRequest) (response *GetSubscriptionItemResponse, err error) {
	response = CreateGetSubscriptionItemResponse()
	err = client.DoAction(request, response)
	return
}

// GetSubscriptionItemWithChan invokes the subscription.GetSubscriptionItem API asynchronously
// api document: https://help.aliyun.com/api/subscription/getsubscriptionitem.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetSubscriptionItemWithChan(request *GetSubscriptionItemRequest) (<-chan *GetSubscriptionItemResponse, <-chan error) {
	responseChan := make(chan *GetSubscriptionItemResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSubscriptionItem(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSubscriptionItemWithCallback invokes the subscription.GetSubscriptionItem API asynchronously
// api document: https://help.aliyun.com/api/subscription/getsubscriptionitem.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetSubscriptionItemWithCallback(request *GetSubscriptionItemRequest, callback func(response *GetSubscriptionItemResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSubscriptionItemResponse
		var err error
		defer close(result)
		response, err = client.GetSubscriptionItem(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSubscriptionItemRequest is the request struct for api GetSubscriptionItem
type GetSubscriptionItemRequest struct {
	*requests.RpcRequest
	Locale string           `position:"Query" name:"Locale"`
	ItemId requests.Integer `position:"Query" name:"ItemId"`
}

// GetSubscriptionItemResponse is the response struct for api GetSubscriptionItem
type GetSubscriptionItemResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	Message          string           `json:"Message" xml:"Message"`
	Code             string           `json:"Code" xml:"Code"`
	Success          bool             `json:"Success" xml:"Success"`
	SubscriptionItem SubscriptionItem `json:"SubscriptionItem" xml:"SubscriptionItem"`
}

// CreateGetSubscriptionItemRequest creates a request to invoke GetSubscriptionItem API
func CreateGetSubscriptionItemRequest() (request *GetSubscriptionItemRequest) {
	request = &GetSubscriptionItemRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Subscription", "2021-01-15", "GetSubscriptionItem", "", "")
	return
}

// CreateGetSubscriptionItemResponse creates a response to parse from GetSubscriptionItem response
func CreateGetSubscriptionItemResponse() (response *GetSubscriptionItemResponse) {
	response = &GetSubscriptionItemResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
