package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// VerifyPythonFile invokes the sophonsoar.VerifyPythonFile API synchronously
func (client *Client) VerifyPythonFile(request *VerifyPythonFileRequest) (response *VerifyPythonFileResponse, err error) {
	response = CreateVerifyPythonFileResponse()
	err = client.DoAction(request, response)
	return
}

// VerifyPythonFileWithChan invokes the sophonsoar.VerifyPythonFile API asynchronously
func (client *Client) VerifyPythonFileWithChan(request *VerifyPythonFileRequest) (<-chan *VerifyPythonFileResponse, <-chan error) {
	responseChan := make(chan *VerifyPythonFileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.VerifyPythonFile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VerifyPythonFileWithCallback invokes the sophonsoar.VerifyPythonFile API asynchronously
func (client *Client) VerifyPythonFileWithCallback(request *VerifyPythonFileRequest, callback func(response *VerifyPythonFileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VerifyPythonFileResponse
		var err error
		defer close(result)
		response, err = client.VerifyPythonFile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VerifyPythonFileRequest is the request struct for api VerifyPythonFile
type VerifyPythonFileRequest struct {
	*requests.RpcRequest
	RoleFor  string `position:"Query" name:"RoleFor"`
	Content  string `position:"Body" name:"Content"`
	RoleType string `position:"Query" name:"RoleType"`
	Lang     string `position:"Query" name:"Lang"`
}

// VerifyPythonFileResponse is the response struct for api VerifyPythonFile
type VerifyPythonFileResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Syntax    []SyntaxItem `json:"Syntax" xml:"Syntax"`
}

// CreateVerifyPythonFileRequest creates a request to invoke VerifyPythonFile API
func CreateVerifyPythonFileRequest() (request *VerifyPythonFileRequest) {
	request = &VerifyPythonFileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "VerifyPythonFile", "", "")
	request.Method = requests.POST
	return
}

// CreateVerifyPythonFileResponse creates a response to parse from VerifyPythonFile response
func CreateVerifyPythonFileResponse() (response *VerifyPythonFileResponse) {
	response = &VerifyPythonFileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
