package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyPlaybookInstanceStatus invokes the sophonsoar.ModifyPlaybookInstanceStatus API synchronously
func (client *Client) ModifyPlaybookInstanceStatus(request *ModifyPlaybookInstanceStatusRequest) (response *ModifyPlaybookInstanceStatusResponse, err error) {
	response = CreateModifyPlaybookInstanceStatusResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyPlaybookInstanceStatusWithChan invokes the sophonsoar.ModifyPlaybookInstanceStatus API asynchronously
func (client *Client) ModifyPlaybookInstanceStatusWithChan(request *ModifyPlaybookInstanceStatusRequest) (<-chan *ModifyPlaybookInstanceStatusResponse, <-chan error) {
	responseChan := make(chan *ModifyPlaybookInstanceStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyPlaybookInstanceStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyPlaybookInstanceStatusWithCallback invokes the sophonsoar.ModifyPlaybookInstanceStatus API asynchronously
func (client *Client) ModifyPlaybookInstanceStatusWithCallback(request *ModifyPlaybookInstanceStatusRequest, callback func(response *ModifyPlaybookInstanceStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyPlaybookInstanceStatusResponse
		var err error
		defer close(result)
		response, err = client.ModifyPlaybookInstanceStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyPlaybookInstanceStatusRequest is the request struct for api ModifyPlaybookInstanceStatus
type ModifyPlaybookInstanceStatusRequest struct {
	*requests.RpcRequest
	RoleFor      string           `position:"Query" name:"RoleFor"`
	Active       requests.Integer `position:"Body" name:"Active"`
	PlaybookUuid string           `position:"Body" name:"PlaybookUuid"`
	RoleType     string           `position:"Query" name:"RoleType"`
	Lang         string           `position:"Query" name:"Lang"`
}

// ModifyPlaybookInstanceStatusResponse is the response struct for api ModifyPlaybookInstanceStatus
type ModifyPlaybookInstanceStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyPlaybookInstanceStatusRequest creates a request to invoke ModifyPlaybookInstanceStatus API
func CreateModifyPlaybookInstanceStatusRequest() (request *ModifyPlaybookInstanceStatusRequest) {
	request = &ModifyPlaybookInstanceStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "ModifyPlaybookInstanceStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyPlaybookInstanceStatusResponse creates a response to parse from ModifyPlaybookInstanceStatus response
func CreateModifyPlaybookInstanceStatusResponse() (response *ModifyPlaybookInstanceStatusResponse) {
	response = &ModifyPlaybookInstanceStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
