package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteExpressSync invokes the sgw.DeleteExpressSync API synchronously
func (client *Client) DeleteExpressSync(request *DeleteExpressSyncRequest) (response *DeleteExpressSyncResponse, err error) {
	response = CreateDeleteExpressSyncResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteExpressSyncWithChan invokes the sgw.DeleteExpressSync API asynchronously
func (client *Client) DeleteExpressSyncWithChan(request *DeleteExpressSyncRequest) (<-chan *DeleteExpressSyncResponse, <-chan error) {
	responseChan := make(chan *DeleteExpressSyncResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteExpressSync(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteExpressSyncWithCallback invokes the sgw.DeleteExpressSync API asynchronously
func (client *Client) DeleteExpressSyncWithCallback(request *DeleteExpressSyncRequest, callback func(response *DeleteExpressSyncResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteExpressSyncResponse
		var err error
		defer close(result)
		response, err = client.DeleteExpressSync(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteExpressSyncRequest is the request struct for api DeleteExpressSync
type DeleteExpressSyncRequest struct {
	*requests.RpcRequest
	ExpressSyncId string `position:"Query" name:"ExpressSyncId"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
}

// DeleteExpressSyncResponse is the response struct for api DeleteExpressSync
type DeleteExpressSyncResponse struct {
	*responses.BaseResponse
	TaskId    string `json:"TaskId" xml:"TaskId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateDeleteExpressSyncRequest creates a request to invoke DeleteExpressSync API
func CreateDeleteExpressSyncRequest() (request *DeleteExpressSyncRequest) {
	request = &DeleteExpressSyncRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DeleteExpressSync", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteExpressSyncResponse creates a response to parse from DeleteExpressSync response
func CreateDeleteExpressSyncResponse() (response *DeleteExpressSyncResponse) {
	response = &DeleteExpressSyncResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
