package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateGateway invokes the sgw.CreateGateway API synchronously
func (client *Client) CreateGateway(request *CreateGatewayRequest) (response *CreateGatewayResponse, err error) {
	response = CreateCreateGatewayResponse()
	err = client.DoAction(request, response)
	return
}

// CreateGatewayWithChan invokes the sgw.CreateGateway API asynchronously
func (client *Client) CreateGatewayWithChan(request *CreateGatewayRequest) (<-chan *CreateGatewayResponse, <-chan error) {
	responseChan := make(chan *CreateGatewayResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateGateway(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateGatewayWithCallback invokes the sgw.CreateGateway API asynchronously
func (client *Client) CreateGatewayWithCallback(request *CreateGatewayRequest, callback func(response *CreateGatewayResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateGatewayResponse
		var err error
		defer close(result)
		response, err = client.CreateGateway(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateGatewayRequest is the request struct for api CreateGateway
type CreateGatewayRequest struct {
	*requests.RpcRequest
	GatewayClass           string           `position:"Query" name:"GatewayClass"`
	GatewayVersion         string           `position:"Query" name:"GatewayVersion"`
	InitCacheSize          requests.Integer `position:"Query" name:"InitCacheSize"`
	PostPaid               requests.Boolean `position:"Query" name:"PostPaid"`
	Description            string           `position:"Query" name:"Description"`
	Type                   string           `position:"Query" name:"Type"`
	ReleaseAfterExpiration requests.Boolean `position:"Query" name:"ReleaseAfterExpiration"`
	SecurityToken          string           `position:"Query" name:"SecurityToken"`
	StorageBundleId        string           `position:"Query" name:"StorageBundleId"`
	InitCacheConfig        string           `position:"Query" name:"InitCacheConfig"`
	InitCacheCategory      string           `position:"Query" name:"InitCacheCategory"`
	VSwitchId              string           `position:"Query" name:"VSwitchId"`
	Name                   string           `position:"Query" name:"Name"`
	Location               string           `position:"Query" name:"Location"`
	Category               string           `position:"Query" name:"Category"`
	PublicNetworkBandwidth requests.Integer `position:"Query" name:"PublicNetworkBandwidth"`
}

// CreateGatewayResponse is the response struct for api CreateGateway
type CreateGatewayResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	GatewayId string `json:"GatewayId" xml:"GatewayId"`
	BuyURL    string `json:"BuyURL" xml:"BuyURL"`
}

// CreateCreateGatewayRequest creates a request to invoke CreateGateway API
func CreateCreateGatewayRequest() (request *CreateGatewayRequest) {
	request = &CreateGatewayRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "CreateGateway", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateGatewayResponse creates a response to parse from CreateGateway response
func CreateCreateGatewayResponse() (response *CreateGatewayResponse) {
	response = &CreateGatewayResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
