package servicemesh

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpgradeMeshVersion invokes the servicemesh.UpgradeMeshVersion API synchronously
func (client *Client) UpgradeMeshVersion(request *UpgradeMeshVersionRequest) (response *UpgradeMeshVersionResponse, err error) {
	response = CreateUpgradeMeshVersionResponse()
	err = client.DoAction(request, response)
	return
}

// UpgradeMeshVersionWithChan invokes the servicemesh.UpgradeMeshVersion API asynchronously
func (client *Client) UpgradeMeshVersionWithChan(request *UpgradeMeshVersionRequest) (<-chan *UpgradeMeshVersionResponse, <-chan error) {
	responseChan := make(chan *UpgradeMeshVersionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpgradeMeshVersion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpgradeMeshVersionWithCallback invokes the servicemesh.UpgradeMeshVersion API asynchronously
func (client *Client) UpgradeMeshVersionWithCallback(request *UpgradeMeshVersionRequest, callback func(response *UpgradeMeshVersionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpgradeMeshVersionResponse
		var err error
		defer close(result)
		response, err = client.UpgradeMeshVersion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpgradeMeshVersionRequest is the request struct for api UpgradeMeshVersion
type UpgradeMeshVersionRequest struct {
	*requests.RpcRequest
	ServiceMeshId string `position:"Query" name:"ServiceMeshId"`
}

// UpgradeMeshVersionResponse is the response struct for api UpgradeMeshVersion
type UpgradeMeshVersionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpgradeMeshVersionRequest creates a request to invoke UpgradeMeshVersion API
func CreateUpgradeMeshVersionRequest() (request *UpgradeMeshVersionRequest) {
	request = &UpgradeMeshVersionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("servicemesh", "2020-01-11", "UpgradeMeshVersion", "servicemesh", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpgradeMeshVersionResponse creates a response to parse from UpgradeMeshVersion response
func CreateUpgradeMeshVersionResponse() (response *UpgradeMeshVersionResponse) {
	response = &UpgradeMeshVersionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
