package servicemesh

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateMeshFeature invokes the servicemesh.UpdateMeshFeature API synchronously
func (client *Client) UpdateMeshFeature(request *UpdateMeshFeatureRequest) (response *UpdateMeshFeatureResponse, err error) {
	response = CreateUpdateMeshFeatureResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateMeshFeatureWithChan invokes the servicemesh.UpdateMeshFeature API asynchronously
func (client *Client) UpdateMeshFeatureWithChan(request *UpdateMeshFeatureRequest) (<-chan *UpdateMeshFeatureResponse, <-chan error) {
	responseChan := make(chan *UpdateMeshFeatureResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateMeshFeature(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateMeshFeatureWithCallback invokes the servicemesh.UpdateMeshFeature API asynchronously
func (client *Client) UpdateMeshFeatureWithCallback(request *UpdateMeshFeatureRequest, callback func(response *UpdateMeshFeatureResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateMeshFeatureResponse
		var err error
		defer close(result)
		response, err = client.UpdateMeshFeature(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateMeshFeatureRequest is the request struct for api UpdateMeshFeature
type UpdateMeshFeatureRequest struct {
	*requests.RpcRequest
	ProxyRequestCPU               string           `position:"Body" name:"ProxyRequestCPU"`
	OPALimitCPU                   string           `position:"Body" name:"OPALimitCPU"`
	OpenAgentPolicy               requests.Boolean `position:"Body" name:"OpenAgentPolicy"`
	OpaEnabled                    requests.Boolean `position:"Body" name:"OpaEnabled"`
	ProxyLimitMemory              string           `position:"Body" name:"ProxyLimitMemory"`
	CniExcludeNamespaces          string           `position:"Body" name:"CniExcludeNamespaces"`
	OPALogLevel                   string           `position:"Body" name:"OPALogLevel"`
	CustomizedZipkin              requests.Boolean `position:"Body" name:"CustomizedZipkin"`
	SidecarInjectorRequestCPU     string           `position:"Body" name:"SidecarInjectorRequestCPU"`
	CniEnabled                    requests.Boolean `position:"Body" name:"CniEnabled"`
	Tracing                       requests.Boolean `position:"Body" name:"Tracing"`
	IncludeIPRanges               string           `position:"Body" name:"IncludeIPRanges"`
	OPALimitMemory                string           `position:"Body" name:"OPALimitMemory"`
	CADisableSecretAutoGeneration requests.Boolean `position:"Body" name:"CADisableSecretAutoGeneration"`
	CAListenedNamespaces          string           `position:"Body" name:"CAListenedNamespaces"`
	ProxyLimitCPU                 string           `position:"Body" name:"ProxyLimitCPU"`
	ProxyRequestMemory            string           `position:"Body" name:"ProxyRequestMemory"`
	Telemetry                     requests.Boolean `position:"Body" name:"Telemetry"`
	OPARequestCPU                 string           `position:"Body" name:"OPARequestCPU"`
	SidecarInjectorWebhookAsYaml  string           `position:"Body" name:"SidecarInjectorWebhookAsYaml"`
	OPARequestMemory              string           `position:"Body" name:"OPARequestMemory"`
	AutoInjectionPolicyEnabled    requests.Boolean `position:"Body" name:"AutoInjectionPolicyEnabled"`
	SidecarInjectorLimitMemory    string           `position:"Body" name:"SidecarInjectorLimitMemory"`
	EnableAudit                   requests.Boolean `position:"Body" name:"EnableAudit"`
	ClusterDomain                 string           `position:"Body" name:"ClusterDomain"`
	SidecarInjectorRequestMemory  string           `position:"Body" name:"SidecarInjectorRequestMemory"`
	ServiceMeshId                 string           `position:"Body" name:"ServiceMeshId"`
	LocalityLoadBalancing         requests.Boolean `position:"Body" name:"LocalityLoadBalancing"`
	SidecarInjectorLimitCPU       string           `position:"Body" name:"SidecarInjectorLimitCPU"`
	TraceSampling                 requests.Float   `position:"Body" name:"TraceSampling"`
	Http10Enabled                 requests.Boolean `position:"Body" name:"Http10Enabled"`
	AppNamespaces                 string           `position:"Body" name:"AppNamespaces"`
	PilotPublicEip                requests.Boolean `position:"Body" name:"PilotPublicEip"`
	AuditProject                  string           `position:"Body" name:"AuditProject"`
	OutboundTrafficPolicy         string           `position:"Body" name:"OutboundTrafficPolicy"`
	EnableNamespacesByDefault     requests.Boolean `position:"Body" name:"EnableNamespacesByDefault"`
}

// UpdateMeshFeatureResponse is the response struct for api UpdateMeshFeature
type UpdateMeshFeatureResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateMeshFeatureRequest creates a request to invoke UpdateMeshFeature API
func CreateUpdateMeshFeatureRequest() (request *UpdateMeshFeatureRequest) {
	request = &UpdateMeshFeatureRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("servicemesh", "2020-01-11", "UpdateMeshFeature", "servicemesh", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateMeshFeatureResponse creates a response to parse from UpdateMeshFeature response
func CreateUpdateMeshFeatureResponse() (response *UpdateMeshFeatureResponse) {
	response = &UpdateMeshFeatureResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
