package servicemesh

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddClusterIntoServiceMesh invokes the servicemesh.AddClusterIntoServiceMesh API synchronously
func (client *Client) AddClusterIntoServiceMesh(request *AddClusterIntoServiceMeshRequest) (response *AddClusterIntoServiceMeshResponse, err error) {
	response = CreateAddClusterIntoServiceMeshResponse()
	err = client.DoAction(request, response)
	return
}

// AddClusterIntoServiceMeshWithChan invokes the servicemesh.AddClusterIntoServiceMesh API asynchronously
func (client *Client) AddClusterIntoServiceMeshWithChan(request *AddClusterIntoServiceMeshRequest) (<-chan *AddClusterIntoServiceMeshResponse, <-chan error) {
	responseChan := make(chan *AddClusterIntoServiceMeshResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddClusterIntoServiceMesh(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddClusterIntoServiceMeshWithCallback invokes the servicemesh.AddClusterIntoServiceMesh API asynchronously
func (client *Client) AddClusterIntoServiceMeshWithCallback(request *AddClusterIntoServiceMeshRequest, callback func(response *AddClusterIntoServiceMeshResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddClusterIntoServiceMeshResponse
		var err error
		defer close(result)
		response, err = client.AddClusterIntoServiceMesh(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddClusterIntoServiceMeshRequest is the request struct for api AddClusterIntoServiceMesh
type AddClusterIntoServiceMeshRequest struct {
	*requests.RpcRequest
	ClusterId     string `position:"Body" name:"ClusterId"`
	ServiceMeshId string `position:"Body" name:"ServiceMeshId"`
}

// AddClusterIntoServiceMeshResponse is the response struct for api AddClusterIntoServiceMesh
type AddClusterIntoServiceMeshResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateAddClusterIntoServiceMeshRequest creates a request to invoke AddClusterIntoServiceMesh API
func CreateAddClusterIntoServiceMeshRequest() (request *AddClusterIntoServiceMeshRequest) {
	request = &AddClusterIntoServiceMeshRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("servicemesh", "2020-01-11", "AddClusterIntoServiceMesh", "servicemesh", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddClusterIntoServiceMeshResponse creates a response to parse from AddClusterIntoServiceMesh response
func CreateAddClusterIntoServiceMeshResponse() (response *AddClusterIntoServiceMeshResponse) {
	response = &AddClusterIntoServiceMeshResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
