package selectdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpgradeDBInstanceEngineVersion invokes the selectdb.UpgradeDBInstanceEngineVersion API synchronously
func (client *Client) UpgradeDBInstanceEngineVersion(request *UpgradeDBInstanceEngineVersionRequest) (response *UpgradeDBInstanceEngineVersionResponse, err error) {
	response = CreateUpgradeDBInstanceEngineVersionResponse()
	err = client.DoAction(request, response)
	return
}

// UpgradeDBInstanceEngineVersionWithChan invokes the selectdb.UpgradeDBInstanceEngineVersion API asynchronously
func (client *Client) UpgradeDBInstanceEngineVersionWithChan(request *UpgradeDBInstanceEngineVersionRequest) (<-chan *UpgradeDBInstanceEngineVersionResponse, <-chan error) {
	responseChan := make(chan *UpgradeDBInstanceEngineVersionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpgradeDBInstanceEngineVersion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpgradeDBInstanceEngineVersionWithCallback invokes the selectdb.UpgradeDBInstanceEngineVersion API asynchronously
func (client *Client) UpgradeDBInstanceEngineVersionWithCallback(request *UpgradeDBInstanceEngineVersionRequest, callback func(response *UpgradeDBInstanceEngineVersionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpgradeDBInstanceEngineVersionResponse
		var err error
		defer close(result)
		response, err = client.UpgradeDBInstanceEngineVersion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpgradeDBInstanceEngineVersionRequest is the request struct for api UpgradeDBInstanceEngineVersion
type UpgradeDBInstanceEngineVersionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	EngineVersion   string           `position:"Query" name:"EngineVersion"`
	SwitchTimeMode  string           `position:"Query" name:"SwitchTimeMode"`
	DBInstanceId    string           `position:"Query" name:"DBInstanceId"`
}

// UpgradeDBInstanceEngineVersionResponse is the response struct for api UpgradeDBInstanceEngineVersion
type UpgradeDBInstanceEngineVersionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpgradeDBInstanceEngineVersionRequest creates a request to invoke UpgradeDBInstanceEngineVersion API
func CreateUpgradeDBInstanceEngineVersionRequest() (request *UpgradeDBInstanceEngineVersionRequest) {
	request = &UpgradeDBInstanceEngineVersionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("selectdb", "2023-05-22", "UpgradeDBInstanceEngineVersion", "", "")
	request.Method = requests.POST
	return
}

// CreateUpgradeDBInstanceEngineVersionResponse creates a response to parse from UpgradeDBInstanceEngineVersion response
func CreateUpgradeDBInstanceEngineVersionResponse() (response *UpgradeDBInstanceEngineVersionResponse) {
	response = &UpgradeDBInstanceEngineVersionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
