package sddp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDataObjects invokes the sddp.DescribeDataObjects API synchronously
func (client *Client) DescribeDataObjects(request *DescribeDataObjectsRequest) (response *DescribeDataObjectsResponse, err error) {
	response = CreateDescribeDataObjectsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDataObjectsWithChan invokes the sddp.DescribeDataObjects API asynchronously
func (client *Client) DescribeDataObjectsWithChan(request *DescribeDataObjectsRequest) (<-chan *DescribeDataObjectsResponse, <-chan error) {
	responseChan := make(chan *DescribeDataObjectsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDataObjects(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDataObjectsWithCallback invokes the sddp.DescribeDataObjects API asynchronously
func (client *Client) DescribeDataObjectsWithCallback(request *DescribeDataObjectsRequest, callback func(response *DescribeDataObjectsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDataObjectsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDataObjects(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDataObjectsRequest is the request struct for api DescribeDataObjects
type DescribeDataObjectsRequest struct {
	*requests.RpcRequest
	FileType          requests.Integer `position:"Query" name:"FileType"`
	RiskLevels        string           `position:"Query" name:"RiskLevels"`
	QueryName         string           `position:"Query" name:"QueryName"`
	DomainId          requests.Integer `position:"Query" name:"DomainId"`
	ParentCategoryIds string           `position:"Query" name:"ParentCategoryIds"`
	SourceIp          string           `position:"Query" name:"SourceIp"`
	ProductIds        string           `position:"Query" name:"ProductIds"`
	PageSize          requests.Integer `position:"Query" name:"PageSize"`
	Lang              string           `position:"Query" name:"Lang"`
	ServiceRegionId   string           `position:"Query" name:"ServiceRegionId"`
	ModelTagIds       string           `position:"Query" name:"ModelTagIds"`
	FeatureType       requests.Integer `position:"Query" name:"FeatureType"`
	FileCategoryCode  requests.Integer `position:"Query" name:"FileCategoryCode"`
	CurrentPage       requests.Integer `position:"Query" name:"CurrentPage"`
	TemplateId        requests.Integer `position:"Query" name:"TemplateId"`
	InstanceId        string           `position:"Query" name:"InstanceId"`
	ModelIds          string           `position:"Query" name:"ModelIds"`
}

// DescribeDataObjectsResponse is the response struct for api DescribeDataObjects
type DescribeDataObjectsResponse struct {
	*responses.BaseResponse
	CurrentPage int    `json:"CurrentPage" xml:"CurrentPage"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
	PageSize    int    `json:"PageSize" xml:"PageSize"`
	TotalCount  int    `json:"TotalCount" xml:"TotalCount"`
	Items       []Rule `json:"Items" xml:"Items"`
}

// CreateDescribeDataObjectsRequest creates a request to invoke DescribeDataObjects API
func CreateDescribeDataObjectsRequest() (request *DescribeDataObjectsRequest) {
	request = &DescribeDataObjectsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sddp", "2019-01-03", "DescribeDataObjects", "sddp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDataObjectsResponse creates a response to parse from DescribeDataObjects response
func CreateDescribeDataObjectsResponse() (response *DescribeDataObjectsResponse) {
	response = &DescribeDataObjectsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
