package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySkillGroups invokes the scsp.QuerySkillGroups API synchronously
func (client *Client) QuerySkillGroups(request *QuerySkillGroupsRequest) (response *QuerySkillGroupsResponse, err error) {
	response = CreateQuerySkillGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySkillGroupsWithChan invokes the scsp.QuerySkillGroups API asynchronously
func (client *Client) QuerySkillGroupsWithChan(request *QuerySkillGroupsRequest) (<-chan *QuerySkillGroupsResponse, <-chan error) {
	responseChan := make(chan *QuerySkillGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySkillGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySkillGroupsWithCallback invokes the scsp.QuerySkillGroups API asynchronously
func (client *Client) QuerySkillGroupsWithCallback(request *QuerySkillGroupsRequest, callback func(response *QuerySkillGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySkillGroupsResponse
		var err error
		defer close(result)
		response, err = client.QuerySkillGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySkillGroupsRequest is the request struct for api QuerySkillGroups
type QuerySkillGroupsRequest struct {
	*requests.RpcRequest
	InstanceId  string           `position:"Query"`
	GroupType   requests.Integer `position:"Query"`
	ClientToken string           `position:"Query"`
	PageNo      requests.Integer `position:"Query"`
	GroupId     requests.Integer `position:"Query"`
	PageSize    requests.Integer `position:"Query"`
	GroupName   string           `position:"Query"`
}

// QuerySkillGroupsResponse is the response struct for api QuerySkillGroups
type QuerySkillGroupsResponse struct {
	*responses.BaseResponse
	OnePageSize  int        `json:"OnePageSize" xml:"OnePageSize"`
	TotalPage    int        `json:"TotalPage" xml:"TotalPage"`
	RequestId    string     `json:"RequestId" xml:"RequestId"`
	CurrentPage  int        `json:"CurrentPage" xml:"CurrentPage"`
	TotalResults int        `json:"TotalResults" xml:"TotalResults"`
	Data         []DataItem `json:"Data" xml:"Data"`
}

// CreateQuerySkillGroupsRequest creates a request to invoke QuerySkillGroups API
func CreateQuerySkillGroupsRequest() (request *QuerySkillGroupsRequest) {
	request = &QuerySkillGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "QuerySkillGroups", "", "")
	request.Method = requests.POST
	return
}

// CreateQuerySkillGroupsResponse creates a response to parse from QuerySkillGroups response
func CreateQuerySkillGroupsResponse() (response *QuerySkillGroupsResponse) {
	response = &QuerySkillGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
