package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetHotlineAgentDetailReport invokes the scsp.GetHotlineAgentDetailReport API synchronously
func (client *Client) GetHotlineAgentDetailReport(request *GetHotlineAgentDetailReportRequest) (response *GetHotlineAgentDetailReportResponse, err error) {
	response = CreateGetHotlineAgentDetailReportResponse()
	err = client.DoAction(request, response)
	return
}

// GetHotlineAgentDetailReportWithChan invokes the scsp.GetHotlineAgentDetailReport API asynchronously
func (client *Client) GetHotlineAgentDetailReportWithChan(request *GetHotlineAgentDetailReportRequest) (<-chan *GetHotlineAgentDetailReportResponse, <-chan error) {
	responseChan := make(chan *GetHotlineAgentDetailReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetHotlineAgentDetailReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetHotlineAgentDetailReportWithCallback invokes the scsp.GetHotlineAgentDetailReport API asynchronously
func (client *Client) GetHotlineAgentDetailReportWithCallback(request *GetHotlineAgentDetailReportRequest, callback func(response *GetHotlineAgentDetailReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetHotlineAgentDetailReportResponse
		var err error
		defer close(result)
		response, err = client.GetHotlineAgentDetailReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetHotlineAgentDetailReportRequest is the request struct for api GetHotlineAgentDetailReport
type GetHotlineAgentDetailReportRequest struct {
	*requests.RpcRequest
	DepIds      *[]string        `position:"Query" name:"DepIds"  type:"Repeated"`
	EndDate     requests.Integer `position:"Query"`
	InstanceId  string           `position:"Query"`
	GroupIds    *[]string        `position:"Query" name:"GroupIds"  type:"Repeated"`
	PageSize    requests.Integer `position:"Query"`
	CurrentPage requests.Integer `position:"Query"`
	StartDate   requests.Integer `position:"Query"`
}

// GetHotlineAgentDetailReportResponse is the response struct for api GetHotlineAgentDetailReport
type GetHotlineAgentDetailReportResponse struct {
	*responses.BaseResponse
	Message   string                            `json:"Message" xml:"Message"`
	RequestId string                            `json:"RequestId" xml:"RequestId"`
	Code      string                            `json:"Code" xml:"Code"`
	Success   string                            `json:"Success" xml:"Success"`
	Data      DataInGetHotlineAgentDetailReport `json:"Data" xml:"Data"`
}

// CreateGetHotlineAgentDetailReportRequest creates a request to invoke GetHotlineAgentDetailReport API
func CreateGetHotlineAgentDetailReportRequest() (request *GetHotlineAgentDetailReportRequest) {
	request = &GetHotlineAgentDetailReportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "GetHotlineAgentDetailReport", "", "")
	request.Method = requests.POST
	return
}

// CreateGetHotlineAgentDetailReportResponse creates a response to parse from GetHotlineAgentDetailReport response
func CreateGetHotlineAgentDetailReportResponse() (response *GetHotlineAgentDetailReportResponse) {
	response = &GetHotlineAgentDetailReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
