package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AssignTicket invokes the scsp.AssignTicket API synchronously
func (client *Client) AssignTicket(request *AssignTicketRequest) (response *AssignTicketResponse, err error) {
	response = CreateAssignTicketResponse()
	err = client.DoAction(request, response)
	return
}

// AssignTicketWithChan invokes the scsp.AssignTicket API asynchronously
func (client *Client) AssignTicketWithChan(request *AssignTicketRequest) (<-chan *AssignTicketResponse, <-chan error) {
	responseChan := make(chan *AssignTicketResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AssignTicket(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AssignTicketWithCallback invokes the scsp.AssignTicket API asynchronously
func (client *Client) AssignTicketWithCallback(request *AssignTicketRequest, callback func(response *AssignTicketResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AssignTicketResponse
		var err error
		defer close(result)
		response, err = client.AssignTicket(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AssignTicketRequest is the request struct for api AssignTicket
type AssignTicketRequest struct {
	*requests.RpcRequest
	ClientToken string           `position:"Body"`
	InstanceId  string           `position:"Body"`
	TicketId    requests.Integer `position:"Body"`
	OperatorId  requests.Integer `position:"Body"`
	AcceptorId  requests.Integer `position:"Body"`
}

// AssignTicketResponse is the response struct for api AssignTicket
type AssignTicketResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateAssignTicketRequest creates a request to invoke AssignTicket API
func CreateAssignTicketRequest() (request *AssignTicketRequest) {
	request = &AssignTicketRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "AssignTicket", "", "")
	request.Method = requests.POST
	return
}

// CreateAssignTicketResponse creates a response to parse from AssignTicket response
func CreateAssignTicketResponse() (response *AssignTicketResponse) {
	response = &AssignTicketResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
