package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyNoticeConfig invokes the sas.ModifyNoticeConfig API synchronously
func (client *Client) ModifyNoticeConfig(request *ModifyNoticeConfigRequest) (response *ModifyNoticeConfigResponse, err error) {
	response = CreateModifyNoticeConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyNoticeConfigWithChan invokes the sas.ModifyNoticeConfig API asynchronously
func (client *Client) ModifyNoticeConfigWithChan(request *ModifyNoticeConfigRequest) (<-chan *ModifyNoticeConfigResponse, <-chan error) {
	responseChan := make(chan *ModifyNoticeConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyNoticeConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyNoticeConfigWithCallback invokes the sas.ModifyNoticeConfig API asynchronously
func (client *Client) ModifyNoticeConfigWithCallback(request *ModifyNoticeConfigRequest, callback func(response *ModifyNoticeConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyNoticeConfigResponse
		var err error
		defer close(result)
		response, err = client.ModifyNoticeConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyNoticeConfigRequest is the request struct for api ModifyNoticeConfig
type ModifyNoticeConfigRequest struct {
	*requests.RpcRequest
	Project   string           `position:"Query" name:"Project"`
	TimeLimit requests.Integer `position:"Query" name:"TimeLimit"`
	Route     requests.Integer `position:"Query" name:"Route"`
	SourceIp  string           `position:"Query" name:"SourceIp"`
}

// ModifyNoticeConfigResponse is the response struct for api ModifyNoticeConfig
type ModifyNoticeConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyNoticeConfigRequest creates a request to invoke ModifyNoticeConfig API
func CreateModifyNoticeConfigRequest() (request *ModifyNoticeConfigRequest) {
	request = &ModifyNoticeConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "ModifyNoticeConfig", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyNoticeConfigResponse creates a response to parse from ModifyNoticeConfig response
func CreateModifyNoticeConfigResponse() (response *ModifyNoticeConfigResponse) {
	response = &ModifyNoticeConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
