package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeImageStatistics invokes the sas.DescribeImageStatistics API synchronously
func (client *Client) DescribeImageStatistics(request *DescribeImageStatisticsRequest) (response *DescribeImageStatisticsResponse, err error) {
	response = CreateDescribeImageStatisticsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeImageStatisticsWithChan invokes the sas.DescribeImageStatistics API asynchronously
func (client *Client) DescribeImageStatisticsWithChan(request *DescribeImageStatisticsRequest) (<-chan *DescribeImageStatisticsResponse, <-chan error) {
	responseChan := make(chan *DescribeImageStatisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeImageStatistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeImageStatisticsWithCallback invokes the sas.DescribeImageStatistics API asynchronously
func (client *Client) DescribeImageStatisticsWithCallback(request *DescribeImageStatisticsRequest, callback func(response *DescribeImageStatisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeImageStatisticsResponse
		var err error
		defer close(result)
		response, err = client.DescribeImageStatistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeImageStatisticsRequest is the request struct for api DescribeImageStatistics
type DescribeImageStatisticsRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// DescribeImageStatisticsResponse is the response struct for api DescribeImageStatistics
type DescribeImageStatisticsResponse struct {
	*responses.BaseResponse
	RequestId         string `json:"RequestId" xml:"RequestId"`
	InstanceCount     int    `json:"InstanceCount" xml:"InstanceCount"`
	RiskInstanceCount int    `json:"RiskInstanceCount" xml:"RiskInstanceCount"`
}

// CreateDescribeImageStatisticsRequest creates a request to invoke DescribeImageStatistics API
func CreateDescribeImageStatisticsRequest() (request *DescribeImageStatisticsRequest) {
	request = &DescribeImageStatisticsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeImageStatistics", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeImageStatisticsResponse creates a response to parse from DescribeImageStatistics response
func CreateDescribeImageStatisticsResponse() (response *DescribeImageStatisticsResponse) {
	response = &DescribeImageStatisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
