package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckSecurityEventId invokes the sas.CheckSecurityEventId API synchronously
func (client *Client) CheckSecurityEventId(request *CheckSecurityEventIdRequest) (response *CheckSecurityEventIdResponse, err error) {
	response = CreateCheckSecurityEventIdResponse()
	err = client.DoAction(request, response)
	return
}

// CheckSecurityEventIdWithChan invokes the sas.CheckSecurityEventId API asynchronously
func (client *Client) CheckSecurityEventIdWithChan(request *CheckSecurityEventIdRequest) (<-chan *CheckSecurityEventIdResponse, <-chan error) {
	responseChan := make(chan *CheckSecurityEventIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckSecurityEventId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckSecurityEventIdWithCallback invokes the sas.CheckSecurityEventId API asynchronously
func (client *Client) CheckSecurityEventIdWithCallback(request *CheckSecurityEventIdRequest, callback func(response *CheckSecurityEventIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckSecurityEventIdResponse
		var err error
		defer close(result)
		response, err = client.CheckSecurityEventId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckSecurityEventIdRequest is the request struct for api CheckSecurityEventId
type CheckSecurityEventIdRequest struct {
	*requests.RpcRequest
	SecurityEventIds *[]string `position:"Query" name:"SecurityEventIds"  type:"Repeated"`
	Uuid             string    `position:"Query" name:"Uuid"`
	SourceIp         string    `position:"Query" name:"SourceIp"`
}

// CheckSecurityEventIdResponse is the response struct for api CheckSecurityEventId
type CheckSecurityEventIdResponse struct {
	*responses.BaseResponse
	Data      bool   `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCheckSecurityEventIdRequest creates a request to invoke CheckSecurityEventId API
func CreateCheckSecurityEventIdRequest() (request *CheckSecurityEventIdRequest) {
	request = &CheckSecurityEventIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "CheckSecurityEventId", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCheckSecurityEventIdResponse creates a response to parse from CheckSecurityEventId response
func CreateCheckSecurityEventIdResponse() (response *CheckSecurityEventIdResponse) {
	response = &CheckSecurityEventIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
