package safe

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SafeChangeQueryApproveFlow invokes the safe.SafeChangeQueryApproveFlow API synchronously
func (client *Client) SafeChangeQueryApproveFlow(request *SafeChangeQueryApproveFlowRequest) (response *SafeChangeQueryApproveFlowResponse, err error) {
	response = CreateSafeChangeQueryApproveFlowResponse()
	err = client.DoAction(request, response)
	return
}

// SafeChangeQueryApproveFlowWithChan invokes the safe.SafeChangeQueryApproveFlow API asynchronously
func (client *Client) SafeChangeQueryApproveFlowWithChan(request *SafeChangeQueryApproveFlowRequest) (<-chan *SafeChangeQueryApproveFlowResponse, <-chan error) {
	responseChan := make(chan *SafeChangeQueryApproveFlowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SafeChangeQueryApproveFlow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SafeChangeQueryApproveFlowWithCallback invokes the safe.SafeChangeQueryApproveFlow API asynchronously
func (client *Client) SafeChangeQueryApproveFlowWithCallback(request *SafeChangeQueryApproveFlowRequest, callback func(response *SafeChangeQueryApproveFlowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SafeChangeQueryApproveFlowResponse
		var err error
		defer close(result)
		response, err = client.SafeChangeQueryApproveFlow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SafeChangeQueryApproveFlowRequest is the request struct for api SafeChangeQueryApproveFlow
type SafeChangeQueryApproveFlowRequest struct {
	*requests.RpcRequest
	AuthKey       string           `position:"Body" name:"AuthKey"`
	ReqTimestamp  requests.Integer `position:"Body" name:"ReqTimestamp"`
	Stage         string           `position:"Body" name:"Stage"`
	SourceOrderId string           `position:"Body" name:"SourceOrderId"`
	AuthSign      string           `position:"Body" name:"AuthSign"`
}

// SafeChangeQueryApproveFlowResponse is the response struct for api SafeChangeQueryApproveFlow
type SafeChangeQueryApproveFlowResponse struct {
	*responses.BaseResponse
	Success   bool       `json:"Success" xml:"Success"`
	Code      int        `json:"Code" xml:"Code"`
	Message   string     `json:"Message" xml:"Message"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateSafeChangeQueryApproveFlowRequest creates a request to invoke SafeChangeQueryApproveFlow API
func CreateSafeChangeQueryApproveFlowRequest() (request *SafeChangeQueryApproveFlowRequest) {
	request = &SafeChangeQueryApproveFlowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Safe", "2022-01-17", "SafeChangeQueryApproveFlow", "", "")
	request.Method = requests.POST
	return
}

// CreateSafeChangeQueryApproveFlowResponse creates a response to parse from SafeChangeQueryApproveFlow response
func CreateSafeChangeQueryApproveFlowResponse() (response *SafeChangeQueryApproveFlowResponse) {
	response = &SafeChangeQueryApproveFlowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
